% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{make_static}
\alias{make_static}
\title{Create static variable, one per participant, using longitudinal responses}
\usage{
make_static(
  data,
  id = "participant_id",
  event = "session_id",
  exclude = NULL,
  var_in,
  var_out
)
}
\arguments{
\item{data}{Dataframe with fields specified in \code{id}, \code{event}, and \code{var}.}

\item{id}{character of length 1. Name of field that contains the IDs for
which we need to assess the longitudinal data.}

\item{event}{character of length 1. Name of field that contains the
(longitudinal) event IDs.}

\item{exclude}{character (vector). The value(s) to be excluded (Default:
NULL; all values are used).}

\item{var_in}{character of length 1. Name of the field that contains the
longitudinal values or responses.}

\item{var_out}{character of length 1. Name of the new field that contains
one static value per \code{id} computed from the longitudinal values or
responses in \code{var_in}.}
}
\value{
Dataframe with two columns: \code{id} and \code{var_out}
}
\description{
Update an existing field to include longitudinal responses.
Use data for each \code{id} from the first available \code{event} and
set that value for all \code{event} rows.
}
\examples{
data <- tibble::tribble(
  ~"id", ~"event", ~"values",
  "A", 1, NA,
  "A", 2, 2,
  "A", 3, 3,
  "B", 1, NA,
  "B", 2, NA,
  "B", 3, 1
)

make_static(
  data,
  var_in = "values",
  var_out = "static_nothing_excluded",
  id = "id",
  event = "event"
)

make_static(
  data,
  var_in = "values",
  var_out = "static_excluding_1and2",
  exclude = c("1", "2"),
  id = "id",
  event = "event"
)

}
