#' Printing method for class `"estimateL"`
#'
#' Internal printing method for `"estimateL"` object generated by `estimateL()`.
#'
#' @param x Object of class `"estimateL"`.
#'
#' @return Does not return a value. It is used to print out the loss estimate along its standard error and confidence interval.
#'
#' @export
#' @keywords internal

print.estimateL <- function(x, ...) {
  temp <- data.frame(
    "Estimate" = x$estimate,
    "Std.Error" = sqrt(x$var),
    "CI.2.5" = stats::qnorm(0.025, mean = x$estimate, sd = sqrt(x$var)),
    "CI.97.5" = stats::qnorm(0.975, mean = x$estimate, sd = sqrt(x$var))
  )
  row.names(temp) <- "Loss"
  print(temp)
  return()
}
