% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahp_geral.R
\name{ahp_geral}
\alias{ahp_geral}
\title{Calculates the AHP General}
\usage{
ahp_geral(objeto, mapeamento = "PADRAO", nomes_alternativas = "PADRAO")
}
\arguments{
\item{objeto}{List of paired arrays or excel path containing the properly formatted paired arrays.}

\item{mapeamento}{Vector containing the number of subscriptions of each criteria, from left to right. If not filled the pattern and fill with 0. If in doubt, see the tutorial vignette.}

\item{nomes_alternativas}{Vector containing the names of the alternatives in your hierarchy,
if not filled returns a vector of LETTERS\[1\:qtdAlternatives\]}
}
\value{
Table containing the relationships of criteria, subscriptions (If any) and Alternatives Using the AHP system.
}
\description{
Calculates AHP in a list of paired arrays or in a properly formatted excel worksheet stipend.
}
\examples{
m1=matrix(c(1, 1/5, 3, 1/5, 1/3,5, 1, 5, 3, 3,
1/3, 1/5, 1, 1/3, 1/3,5, 1/3, 3, 1, 1,3, 1/3,
3, 1, 1),ncol=5,byrow=TRUE)
m2=matrix(c(1, 1/3, 1/6, 3, 1, 1/2,6, 2, 1),nrow=3, byrow=TRUE)
m3=matrix(c(1, 1/2, 1/2,2, 1, 2, 2, 1/2, 1),nrow=3, byrow=TRUE)
m4=matrix(c(1, 1, 2,1, 1, 1, 1/2, 1, 1),nrow=3, byrow=TRUE)
m5=matrix(c(1, 2, 3,1/2, 1, 2, 1/3, 1/2, 1),nrow=3, byrow=TRUE)
m6=matrix(c(1, 5, 3,1/5, 1, 1/3, 1/3, 3, 1),nrow=3, byrow=TRUE)
base=list(m1,m2,m3,m4,m5,m6)
mapeamento=rep(0,5)
nomes_alternativas="PADRAO"
ahp_geral(base,mapeamento, nomes_alternativas)
}
\author{
Lyncoln Oliveira
}
