% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure.R
\docType{class}
\name{aniso_SAM-class}
\alias{aniso_SAM-class}
\title{Anisotropic SAM class}
\description{
S4 class for fast parameter estimation in scattering analysis of microscopy
for anisotropic processes, using either \code{AIUQ} or \code{DDM} method.
}
\section{Slots}{

\describe{
\item{\code{pxsz}}{numeric.  Size of one pixel in unit of micron with default value 1.}

\item{\code{mindt}}{numeric. Minimum lag time with default value 1.}

\item{\code{sz}}{vector. Frame size of the intensity profile in x and y directions,
number of pixels contained in each frame equals sz_x by sz_y.}

\item{\code{len_t}}{integer. Number of time steps.}

\item{\code{len_q}}{integer. Number of wave vector.}

\item{\code{q}}{vector. Wave vector in unit of um^-1.}

\item{\code{d_input}}{vector. Sequence of lag times.}

\item{\code{B_est_ini}}{numeric. Estimation of B. This parameter is determined by the
noise in the system. See 'References'.}

\item{\code{A_est_ini}}{vector. Estimation of A(q). Note this parameter is
determined by the properties of the imaged material and imaging optics.
See 'References'.}

\item{\code{I_o_q_2_ori}}{vector. Absolute square of Fourier transformed intensity
profile, ensemble over time.}

\item{\code{q_ori_ring_loc_unique_index}}{list. List of location index of non-duplicate
values for each q ring.}

\item{\code{model_name}}{character. Fitted model, options from
('BM','OU','FBM','OU+FBM', 'user_defined').}

\item{\code{param_est}}{matrix. Estimated parameters contained in MSD.}

\item{\code{sigma_2_0_est}}{vector. Estimated variance of background noise.}

\item{\code{msd_est}}{matrix. Estimated MSD.}

\item{\code{uncertainty}}{logical. A logical evaluating to TRUE or FALSE indicating whether
parameter uncertainty should be computed.}

\item{\code{msd_truth}}{matrix. True MSD or reference MSD value.}

\item{\code{sigma_2_0_truth}}{vector.  True variance of background noise, non NA for
simulated data using \code{simulation}.}

\item{\code{param_truth}}{matrix. True parameters used to construct MSD, non NA for
simulated data using \code{aniso_simulation}.}

\item{\code{index_q}}{vector. Selected index of wave vector.}

\item{\code{I_q}}{matrix. Fourier transformed intensity profile with structure 'SS_T_mat'.}

\item{\code{AIC}}{numeric. Akaike information criterion score.}

\item{\code{mle}}{numeric. Maximum log likelihood value.}

\item{\code{msd_x_lower}}{vector. Lower bound of 95\% confidence interval of MSD in x directions.}

\item{\code{msd_x_upper}}{vector. Upper bound of 95\% confidence interval of MSD in x directions.}

\item{\code{msd_y_lower}}{vector. Lower bound of 95\% confidence interval of MSD in y directions.}

\item{\code{msd_y_upper}}{vector. Upper bound of 95\% confidence interval of MSD in y directions.}

\item{\code{param_uq_range}}{matrix. 95\% confidence interval for estimated parameters.}
}}

\references{
Gu, M., He, Y., Liu, X., & Luo, Y. (2023). Ab initio uncertainty
quantification in scattering analysis of microscopy.
arXiv preprint arXiv:2309.02468.

Gu, M., Luo, Y., He, Y., Helgeson, M. E., & Valentine, M. T. (2021).
Uncertainty quantification and estimation in differential dynamic microscopy.
Physical Review E, 104(3), 034610.

Cerbino, R., & Trappe, V. (2008). Differential dynamic microscopy: probing
wave vector dependent dynamics with a microscope. Physical review letters,
100(18), 188102.
}
\author{
\packageAuthor{AIUQ}
}
\keyword{classes}
