% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOFA-plot.R
\name{count}
\alias{count}
\alias{anofaPlot}
\alias{init.count}
\alias{CI.count}
\title{anofaPlot.}
\usage{
anofaPlot(w, formula, confidenceLevel = .95, showPlotOnly = TRUE, plotStyle = "line", 
    errorbarParams  = list( width =0.5, linewidth=0.75 ), ...)

count(n)

init.count(df)

CI.count(n, gamma =0.95)
}
\arguments{
\item{n}{the count for which a confidence interval is required}

\item{w}{An ANOFA object obtained with \code{anofa()};}

\item{formula}{(optional) Use formula to plot just specific terms of the omnibus test.
For example, if your analysis stored in \code{w} has factors A, B and C, then
\code{anofaPlot(w, ~ A * B)} will only plot the factors A and B.}

\item{confidenceLevel}{Provide the confidence level for the confidence intervals.
(default is 0.95, i.e., 95\%).}

\item{plotStyle}{(optional; default "line") How to plot the frequencies. See superb for other layouts
(e.g., "line")}

\item{showPlotOnly}{(optional, default True) shows only the plot or else shows the numbers
needed to make the plot yourself.}

\item{errorbarParams}{(optional; default list( width =0.5, linewidth=0.75 ) ) A list of
attributes used to plot the error bars. See superb for more.}

\item{...}{Other directives sent to superb(), typically 'plotStyle', 'errorbarParams', etc.}

\item{df}{a data frame for initialization of the CI function}

\item{gamma}{the confidence level}
}
\value{
a ggplot2 object of the given frequencies.
}
\description{
The function \code{anofaPlot()} performs a plot of frequencies for designs
with up to 4 factors according to the
\code{ANOFA} framework. See \insertCite{lc23b;textual}{ANOFA} for more. The plot is
realized using the \code{suberb} library; see \insertCite{cgh21;textual}{ANOFA}.
The functions \code{count()}, \code{init.count()} and \code{CI.count()} are internal functions.
}
\details{
The plot shows the frequencies (the count of cases) on the vertical axis as a
function of the factors (the first on the horizontal axis, the second if any in a legend;
and if a third or even a fourth factors are present, as distinct rows and columns).
It also shows 95\% confidence intervals of the frequency, adjusted for between-cells
comparisons. The confidence intervals are based on the Clopper and Pearson method
\insertCite{cp34}{ANOFA} using the Leemis and Trivedi
analytic formula \insertCite{lt96}{ANOFA}. This "stand-alone" confidence
interval is then adjusted for between-cell comparisons using the superb framework
\insertCite{cgh21}{ANOFA}.

See the vignette \code{DataFormatsForFrequencies} for more on data format and how to write their
formula. See the vignette \code{ConfidenceInterval} for details on the adjustment and its purpose.
}
\examples{
# 
# The Landis et al. (2013) example has two factors, program of treatment and provider of services.
LandisBarrettGalvin2013

# This examine the omnibus analysis, that is, a 5 (provider) x 3 (program):
w <- anofa(obsfreq ~ provider * program, LandisBarrettGalvin2013) 

# Once processed into w, we can ask for a standard plot
anofaPlot(w)

# We place the factor `program` on the x-axis:
anofaPlot(w,  factorOrder = c("program","provider"))

# The above example can also be obtained with a formula:
anofaPlot(w, ~ program * provider)

# Change the style for a plot with bars instead of lines
anofaPlot(w, plotStyle = "bar")

# Changing the error bar style
anofaPlot(w, plotStyle = "bar", errorbarParams = list( width =0.1, linewidth=0.1 ) )

# An example with 4 factors:
\dontrun{
dta <- data.frame(Detergent)
dta

w <- anofa( Freq ~ Temperature * M_User * Preference * Water_softness, dta )
anofaPlot(w)
anofaPlot(w, factorOrder = c("M_User","Preference","Water_softness","Temperature")) 


# Illustrating the main effect of Temperature (not interacting with other factors)
# and the interaction Preference * Previously used M brand
# (Left and right panels of Figure 4 of the main article)
anofaPlot(w, ~ Temperature)
anofaPlot(w, ~ Preference * M_User)

# All these plots are ggplot2 so they can be followed with additional directives, e.g.
library(ggplot2)
anofaPlot(w, ~ Temperature) + ylim(200,800) + theme_classic()
anofaPlot(w, ~ Preference * M_User) + ylim(100,400) + theme_classic()
}
# etc. Any ggplot2 directive can be added to customize the plot to your liking.
# See the vignette `Example2`.


}
\references{
\insertAllCited{}
}
