% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_housing_quality.R
\name{calc_housing_quality}
\alias{calc_housing_quality}
\title{Calculate Housing Quality Needs}
\usage{
calc_housing_quality(survey_df)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer_concept_id`.}
}
\value{
A data frame with two columns: `person_id` and `housing_quality`, where `housing_quality`
is a TRUE or FALSE indicator for each participant. TRUE indicates the participant selected at least one housing problem, and FALSE indicates no housing problems.
Participants without data will have NA values.
}
\description{
This function creates a binary categorical variable indicating whether a participant endorses having any housing-related problems (housing need).
A value of TRUE indicates the participant selected at least one housing problem, while FALSE indicates no problems were reported.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = c(1, 2, 3, 4, 5, 6, 7),
  question_concept_id = rep(40192402, 7),
  answer_concept_id = c(40192392, 40192479, 40192444, 40192460,
                        40192434, 40192468, 40192393)
)

# Compute housing quality needs
housing_quality_scores <- calc_housing_quality(survey_df)
head(housing_quality_scores)

}
