% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aov1r.R
\name{aov1r}
\alias{aov1r}
\alias{summary.aov1r}
\alias{print.summary.aov1r}
\title{One-way random effect ANOVA}
\usage{
aov1r(formula, data = NULL)

\method{summary}{aov1r}(object, ...)

\method{print}{summary.aov1r}(x, ...)
}
\arguments{
\item{formula}{a formula of the form \code{y~group}}

\item{data}{optional dataframe}

\item{object}{an \code{aov1r} object (output of an \code{aov1r} call)}

\item{...}{ignored}

\item{x}{output of \code{summary}}
}
\value{
\code{aov1r} returns an object of class \code{aov1r};
}
\description{
Fits a one-way random effect ANOVA model.
}
\examples{
dat <- simAOV1R(I=2, J=3, mu=10, sigmab=1, sigmaw=1)
fit <- aov1r(y ~ group, data=dat)
summary(fit)
}
