% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argos_files.R
\name{build_design_matrix}
\alias{build_design_matrix}
\title{Build Design Matrix}
\usage{
build_design_matrix(
  x_t,
  dt = 1,
  sg_poly_order = 4,
  library_degree = 5,
  library_type = c("poly", "four", "poly_four")
)
}
\arguments{
\item{x_t}{Matrix of observations.}

\item{dt}{Time step (default is 1).}

\item{sg_poly_order}{Polynomial order for Savitzky-Golay Filter.}

\item{library_degree}{Degree of polynomial library (default is 5).}

\item{library_type}{Type of library to use. Can be one of "poly",
"four", or "poly_four".}
}
\value{
A list with two elements:
\itemize{
  \item \code{sorted_theta} - A matrix with sorted polynomial/trigonometric
        terms.
  \item \code{monomial_orders} - A vector indicating the order of each
        polynomial term.
  \item \code{xdot_filtered} - A matrix with derivative terms
        (dependent variable).
}
}
\description{
This function first smooths the data and approximates the
derivative before building the design matrix to include monomial and fourier
terms.
}
\examples{
# Build a design matrix using the Duffing Oscillator as the state-space.
# Output provides matrix, and derivative matrix monomial orders
# (needed for running `argos`).
x_t <- duffing_oscillator(n=5000, dt = 0.01,
                          init_conditions = c(1, 0),
                          gamma_value = 0.1, kappa_value = 1,
                          epsilon_value = 5, snr = 49)
duffing_design_matrix <-
         build_design_matrix(x_t, dt = 0.01, sg_poly_order = 4,
                             library_degree = 5, library_type = "poly")
head(duffing_design_matrix$sorted_theta)
}
