% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{computeMHPBoundaries}
\alias{computeMHPBoundaries}
\title{Compute the three modified Haybittle-Peto boundaries}
\usage{
computeMHPBoundaries(prevalence, N, alpha, beta, eps, futilityOnly = FALSE)
}
\arguments{
\item{prevalence}{the vector of prevalences between 0 and 1 summing
to 1. \eqn{J}, the number of groups, is implicitly the length
of this vector and should be at least 2.}

\item{N}{a three-vector of total sample size at each stage}

\item{alpha}{the type I error}

\item{beta}{the type II error}

\item{eps}{the fraction (between 0 and 1) of the type 1 error to
spend in the interim stages 1 and 2}

\item{futilityOnly}{a logical value indicating only the futility
boundary is to be computed; default \code{FALSE}}
}
\value{
a named vector of three values containing
\eqn{\tilde{b}}{btilde}, b, c
}
\description{
Compute the three modified Haybittle-Peto boundaries
}
