% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{mHP.b}
\alias{mHP.b}
\title{Compute the efficacy boundary (modified Haybittle-Peto) for the
first two stages}
\usage{
mHP.b(prevalence, N, cov.J, mu.prime, Sigma.prime, alpha, btilde, theta)
}
\arguments{
\item{prevalence}{the vector of prevalences between 0 and 1 summing
to 1. \eqn{J}, the number of groups, is implicitly the length
of this vector and should be at least 2.}

\item{N}{a three-vector of total sample size at each stage}

\item{cov.J}{the 3 x 3 covariance matrix for Z_J at each of the
three stages}

\item{mu.prime}{a list of \eqn{J} mean vectors, each of length
\eqn{J-1} representing the conditional means of all the other
\eqn{Z_j} given \eqn{Z_i}. This mean does not account for the
conditioned value of \eqn{Z_i} and so has to be multiplied by
that during use!}

\item{Sigma.prime}{a list of \eqn{J} covariance matrices, each
\eqn{J-1} by \eqn{J-1} representing the conditional covariances
all the other \eqn{Z_j} given \eqn{Z_i}}

\item{alpha}{the amount of type I error to spend}

\item{btilde}{the futility boundary}

\item{theta}{the effect size on the probability scale}
}
\description{
Compute the efficacy boundary (modified Haybittle-Peto) for the
first two stages
}
