% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATE.ERROR.Y.R
\name{ATE.ERROR.Y}
\alias{ATE.ERROR.Y}
\title{ATE.ERROR.Y Function for Estimating Average Treatment Effect (ATE) with Misclassification in Y}
\usage{
ATE.ERROR.Y(Y_star, A, Z, X, p11, p10, bootstrap_number = 250)
}
\arguments{
\item{Y_star}{Numeric vector. The observed binary outcome variable, which may be subject to misclassification.}

\item{A}{Numeric vector. The binary treatment indicator (1 if treated, 0 if control).}

\item{Z}{Numeric vector. A precisely measured covariate vector.}

\item{X}{Numeric vector. A precisely measured covariate vector.}

\item{p11}{Numeric. The probability of correctly classified Y given Y = 1.}

\item{p10}{Numeric. The probability of misclassified Y given Y = 0.}

\item{bootstrap_number}{Integer. The number of bootstrap samples (default is 250) used to obtain the associated variance estimate.}
}
\value{
A list containing:
\describe{
\item{summary}{A data frame with the following columns:
\itemize{
\item \strong{Naive_ATE}: Naive estimate of the ATE, ignoring misclassification.
\item \strong{ATE}: Mean ATE estimate from the bootstrap samples, accounting for misclassification.
\item \strong{SE}: Standard error of the ATE estimate.
\item \strong{CI}: 95\% confidence interval for the ATE estimate.
}
}
\item{boxplot}{A ggplot object representing the boxplot of the ATE estimates.}
}
}
\description{
This function performs estimation of the Average Treatment Effect (ATE) using the ATE.ERROR.Y method,
which accounts for misclassification in the binary outcome variable Y. The method calculates consistent estimates
of the ATE in the presence of misclassified outcomes by leveraging logistic regression and bootstrap sampling.
}
\details{
The function first calculates consistent estimates of the ATE, correcting for misclassification in the outcome variable Y.
The logistic model is used to estimate the propensity scores for the treatment assignment, which are then adjusted using the provided
misclassification probabilities p11 and p10. Bootstrap sampling is performed to estimate the variance and construct confidence intervals
for the ATE estimates.
}
\examples{
library(ATE.ERROR)
data(Simulated_data)
Y_star <- Simulated_data$Y_star
A <- Simulated_data$T
Z <- Simulated_data$Z
X <- Simulated_data$X
p11 <- 0.8
p10 <- 0.2
bootstrap_number <- 250
result <- ATE.ERROR.Y(Y_star, A, Z, X, p11, p10, bootstrap_number)
print(result$summary)
print(result$boxplot)

}
