% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross.R
\name{cross}
\alias{cross}
\title{Performing crossover\cr}
\usage{
cross(parents, heredity = "Strong", nmain.p, r1, r2, interaction.ind = NULL)
}
\arguments{
\item{parents}{A numeric matrix of dimension \code{q} by \code{r1+r2},
obtained from \code{initial} or previous generation where each row corresponding
a fitted model and each column representing the predictor index in the fitted model.}

\item{heredity}{Whether to enforce Strong, Weak, or No heredity. Default is "Strong".}

\item{nmain.p}{A numeric value that represents the total number of main effects
in \code{X}.}

\item{r1}{A numeric value indicating the maximum number of main effects.}

\item{r2}{A numeric value indicating the maximum number of interaction effects.}

\item{interaction.ind}{A two-column numeric matrix containing all possible
two-way interaction effects. It must be generated outside of this function
using \code{t(utils::combn())}. See Example section for details.}
}
\value{
A numeric matrix \code{single.child.bit} is returned. Each row representing
a fitted model, and each column corresponding to the predictor index in the fitted model.
Duplicated models are allowed.
}
\description{
This function performs crossover which only stores all fitted models without
making any comparison. The selected indices in each fitted model will be
automatically re-ordered so that main effects comes first, followed by
two-way interaction effects, and zero reservation spaces.
}
\examples{
# Under Strong heredity
set.seed(0)
nmain.p <- 4
interaction.ind <- t(combn(4,2))
X <- matrix(rnorm(50*4,1,0.1), 50, 4)
epl <- rnorm(50,0,0.01)
y<- 1+X[,1]+X[,2]+X[,1]*X[,2]+epl
p1 <- initial(X, y, nmain.p = 4, r1 = 3, r2 = 3,
    interaction.ind = interaction.ind, q = 5)
c1 <- cross(p1, nmain.p=4, r1 = 3, r2 = 3,
    interaction.ind = interaction.ind)
}
\seealso{
\code{\link{initial}}.
}
