% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call-adherer-external.R
\name{callAdhereR}
\alias{callAdhereR}
\title{callAdhereR.}
\usage{
callAdhereR(shared.data.directory)
}
\arguments{
\item{shared.data.directory}{A \emph{string} containing the path to the
directory where all the exchanged (shared) data (both input and output) is.
\code{AdhereR} needs read and write access to this directory.}
}
\value{
This function displays any messages to the console, tries to also
write them to the \code{Adherer-results.txt} file in the
\code{shared.data.directory} directory, and, when finished, forces \code{R}
to quit with a given shell error code:
\itemize{
 \item \code{0} The processing ended without major errors;
 \item \code{1} General error (hopefully there are messages in the
                \code{Adherer-results.txt} file;
 \item \code{10} The directory \code{shared.data.directory} does not exit;
 \item \code{11} \code{AdhereR} does not have read access to the
                 \code{shared.data.directory} directory;
 \item \code{12} \code{AdhereR} does not have write access to the
                 \code{shared.data.directory} directory;
 \item \code{13} issues with the parameters file \code{parameters.log};
 \item \code{14} issues with the data file \code{dataset.csv};
 \item \code{15} plotting issues;
 \item \code{16} interactive plotting issues;
 \item \code{17} issues exporting the results.
}
}
\description{
The function encapsulating all the logics that allows AdhereR to be called
from any platform using the generic \code{shell} mechanism.
}
\details{
In most cases this should not be done directly by the user,
but instead used by an appropriate \code{wrapper} on the client platform.
It allows transparent use of \code{AdhereR} from virtually any platform or
programming language for which an appropriate wrapper is provided.
For more details see the vignette describing the included reference
\code{Python 3} wrapper.
}
