% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Isotherms.R
\name{nonlinear_freundlich}
\alias{nonlinear_freundlich}
\title{Non-linear Freundlich Model}
\usage{
nonlinear_freundlich(Ce, Qe)
}
\arguments{
  \item{Ce}{Numeric vector of equilibrium concentrations.}

  \item{Qe}{Numeric vector of amount adsorbed.}
}
\value{
A named list of Freundlich parameters and model details, including parameter estimates, model diagnostics, and a diagnostic plot.
}
\description{
The non-linear Freundlich isotherm model is an empirical equation describing adsorption on heterogeneous surfaces.
It assumes that adsorption sites are not uniform and that binding energy decreases exponentially with surface coverage.

The model is given by:

\deqn{Q = K_f \cdot C_e^{1/n}}

where \eqn{Q} is the amount adsorbed, \eqn{C_e} is the equilibrium concentration,
\eqn{K_f} is the Freundlich constant (adsorption capacity), and \eqn{n} is the heterogeneity index
(indicating adsorption intensity).

This function fits the Freundlich model using non-linear least squares regression.
}
\examples{
Ce <- c(0.5, 1, 2, 4, 6, 8)
Qe <- c(0.3, 0.8, 1.6, 2.4, 2.9, 3.2)
result <- nonlinear_freundlich(Ce, Qe)
print(result$`Freundlich Kf`)
print(result$`Freundlich n`)
print(result$AIC)
print(result$`Pseudo R2`)
print(result$Plot)
}
\seealso{
Other nonlinear models: \code{\link{nonlinear_bet}()}, \code{\link{nonlinear_langmuir}()}, \code{\link{nonlinear_temkin}()}
}
\concept{nonlinear}

