% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desd_fat2_quant_ad.R
\name{desd_fat2_quant_ad}
\alias{desd_fat2_quant_ad}
\title{Analysis: Regression analysis by orthogonal polynomials for double factorial scheme with additional control}
\usage{
desd_fat2_quant_ad(output, ad.value = 0, design = "FAT2DIC.ad", grau = 1)
}
\arguments{
\item{output}{Output from a FAT2DIC.ad or FAT2DBC.ad function (Use quantity factor as f2).}

\item{ad.value}{Additional treatment quantitative factor level}

\item{design}{Type of experimental project (FAT2DIC.ad or FAT2DBC.ad)}

\item{grau}{Degree of the polynomial (only for the isolated effect of the quantitative factor)}
}
\description{
Regression analysis by orthogonal polynomials for double factorial scheme with additional control. Cases in which the additional belongs to the regression curve, being common to the qualitative levels. In these cases, the additional (usually dose 0/control treatment) is not part of the factor arrangement. One option addressed by this function is to analyze a priori as a double factorial scheme with an additional one and correct the information a posteriore using information from the initial analysis, such as the degree of freedom and the sum of squares of the residue.
}
\examples{

#==================================================
# Data set
trat=rep(c("A","B","C"),e=12)
dose=rep(rep(c(200,400,600,800),e=3),3)
d0=c(40,45,48)
respo=c(60,55,56, 60,65,66, 70,75,76,
        80,85,86, 50,55,56, 70,75,76,
        60,65,66, 50,45,46, 50,45,46,
        50,55,66, 70,75,76, 80,85,86)
repe=rep(c("R1","R2","R3"),12)
#==================================================
# Analysis FAT2DIC.ad
resu=FAT2DIC.ad(trat,dose,repe = repe,respo,responseAd = d0,quali = c(TRUE,FALSE),grau21 = c(1,2,1))

#==================================================
# Regression analysis
desd_fat2_quant_ad(resu,ad.value=0,design="FAT2DIC.ad")


# Data set
trat=rep(c("A","B"),e=12)
dose=rep(rep(c(200,400,600,800),e=3),2)
d0=c(40,45,48)
respo=c(60,55,56,60,65,66,70,75,76,80,85,86,50,45,46,50,55,66,70,75,76,80,85,86)
repe=rep(c("R1","R2","R3"),8)
#==================================================
# Analysis FAT2DIC.ad
resu=FAT2DIC.ad(trat,dose,repe = repe,respo,responseAd = d0,quali = c(TRUE,FALSE))
#==================================================
# Regression analysis
desd_fat2_quant_ad(resu,ad.value=0,design="FAT2DIC.ad",grau=1)
}
\author{
Gabriel Danilo Shimizu, \email{gabrield.shimizu@gmail.com}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
