% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPrule.R
\name{CPrule}
\alias{CPrule}
\title{Constrained proportional rule}
\usage{
CPrule(c)
}
\arguments{
\item{c}{A numeric cost vector.}
}
\value{
A numeric contribution vector, where each element represents the payment of the different agents.
}
\description{
\code{CPrule} calculates the contribution vector selected by the CP rule.
}
\details{
For each \eqn{c\in C^N}, let \eqn{c_0=0} and \eqn{(q_0,q_1,\dots,q_s)\in\mathbb{N}^{s+1}}, with
\eqn{0=q_0<q_1<\dots<q_s=n}, defined recursively, for \eqn{j\geq 0}, by
\deqn{
q_{j+1}=\text{max}\Bigg\{q\in N_{+}^{q_j}:\dfrac{c_q-c_{q_j}}{c_{q_j+1}+\dots+c_q}=\text{min}\bigg\{\dfrac{c_r-c_{q_j}}{c_{q_j+1}+\dots+c_r}:r\in N_{+}^{q_j}\bigg\}\Bigg\}.
}
Then, for each \eqn{j\in\{0,\dots,s-1\}} and each \eqn{i\in Q_j=\{q_j+1,\dots,q_{j+1}\}},
\deqn{
\text{CP}_i(c)=\dfrac{c_i}{c(Q_j)}(c_{q_{j+1}}-c_{q_j}).
}
With this rule, calculating each agent's contribution is not always straightforward.
When a coalition of agents violates the NS constraint, it becomes necessary to proceed in two or more steps.

The core idea of this rule is proportionality, aiming to ensure that agents' contributions are as close as
possible to being proportional to the cost parameters, while respecting these constraints.
}
\examples{
c <- c(1, 3, 7, 10) # Cost vector
CPrule(c)

}
\references{
Bernárdez Ferradás, A., Mirás Calvo, M. Á., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2025). Airport problems with cloned agents. [Preprint manuscript].

Thomson, W. (2024). Cost allocation and airport problems.
\emph{Mathematical Social Sciences}, 31(C), 17–31.
}
\seealso{
\code{\link{basicrule}}, \code{\link{weightedrule}}, \code{\link{clonesrule}}, \code{\link{hierarchicalrule}}
}
