% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicrule.R
\name{basicrule}
\alias{basicrule}
\title{Allocation rule}
\usage{
basicrule(c, rule, a = NULL, order = NULL)
}
\arguments{
\item{c}{A numeric cost vector.}

\item{rule}{A character string specifying the rule to apply.The rules that can be selected are:
\code{"SFC"}, \code{"SEC"}, \code{"CEC"}, \code{"CP"}, \code{"CEB"}, \code{"SM"}, \code{"CC"}, \code{"SIGMA"} and \code{"PRIOR"}.}

\item{a}{A numeric value in the range [0,1], controlling the parameterization of the rule. It can only be defined when \code{rule = "SIGMA"}.
By default, \code{a = 0.5}.}

\item{order}{A numeric vector indicating the priority order of agents when making contributions. It can only be defined when \code{rule = "PRIOR"}.
By default, agents follow their original indexing and contribute accordingly.}
}
\value{
A numeric contribution vector, where each element represents the payment of the different agents.
}
\description{
\code{basicrule} calculates the contribution vector resulting from the payment allocation among the different agents using one of the various predefined rules.
}
\details{
A rule is a mapping \eqn{\mathcal{R}:C^N\rightarrow \mathbb{R}^N} which associates with each problem \eqn{c\in C^N} a cost allocation vector
\eqn{\mathcal{R}(c)} such that \eqn{0\leq\mathcal{R}(c)\leq c}. In other words, a rule is a mechanism that selects for each airport problem an allocation vector.

The various proposed rules, despite their differences, share a key characteristic: for any given problem,
each rule selects an allocation vector that belongs to its no-subsidy set.
Although these rules have been individually characterized in different functions, the one in question encompasses all of them.
}
\note{
When \code{rule = "CC"}, the execution time of the function may significantly increase if the number of agents exceeds 150.
}
\examples{
c <- c(1, 3, 7, 10) # Cost vector

# SEC rule
basicrule(c, rule = "SEC")

# PRIOR rule
order <- c(1, 3, 2, 4)
basicrule(c, "PRIOR", order = order)

}
\references{
Bernárdez Ferradás, A., Mirás Calvo, M. Á., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2025). Airport problems with cloned agents. [Preprint manuscript].

Potters, J. and Sudhölter, P. (1999). Airport problems and consistent allocation rules.
\emph{Mathematical Social Sciences}, 38, 83–102.

Thomson, W. (2024). Cost allocation and airport problems.
\emph{Mathematical Social Sciences}, 31(C), 17–31.
}
\seealso{
\code{\link{NSset}}, \code{\link{weightedrule}}, \code{\link{clonesrule}}, \code{\link{hierarchicalrule}}, \code{\link{multibasicrules}}
}
