% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiweightedrules.R
\name{multiweightedrules}
\alias{multiweightedrules}
\title{Overview of the weighted allocation rules}
\usage{
multiweightedrules(
  c,
  w,
  rules = c("SFC", "SEC", "CSEC", "CEC", "CEB", "CP"),
  draw = TRUE,
  col = NULL,
  agents_names = NULL,
  labels = TRUE
)
}
\arguments{
\item{c}{A numeric cost vector.}

\item{w}{A numeric weight vector.}

\item{rules}{A character vector specifying the allocation rules. The available rules are:
\code{"SFC"}, \code{"SEC"}, \code{"CSEC"}, \code{"CEC"}, \code{"CP"} and \code{"CEB"}. By default, all the rules
are selected.}

\item{draw}{A logical value indicating whether the plot should be generated. By default, \code{draw = TRUE}.}

\item{col}{A vector that indicates the colors used to represent each agent in the graphical representation. By default,
the colors are selected by the function \code{rainbow()}.}

\item{agents_names}{A vector defining the name assigned to each agent. By default, the names follow a sequence of natural numbers, starting from 1.}

\item{labels}{A logical value indicating whether the labels and the title of the plot should be displayed. By default, \code{labels = TRUE}.}
}
\value{
A data frame containing the contribution vectors determined by the selected allocation rules. Additionally, if \code{draw = TRUE},
a mosaic plot displaying the allocations obtained for the different weighted rules.
}
\description{
\code{multiweightedrules} calculates the contribution vectors resulting from the allocation of payments among different agents, applying various predefined weighted rules.
It also generates a graphical representation of the allocations based on the implemented weighted rules.
}
\details{
Let \eqn{w=(w_i)_{i\in N}\in\mathbb{R}^n} be a positive weight vector, satisfying \eqn{w_i> 0} for all
\eqn{i\in N} and \eqn{w(N)=1}. Consider the \eqn{(n-1)}-standard simplex, defined as \eqn{\Delta_n=\{x\in\mathbb{R}^n:x\geq 0, \ x_1+\dots+x_n=1\}}.
Then, the set of all positive weight vectors corresponds to \eqn{\text{Int}(\Delta_n)}, the interior of the
\eqn{(n-1)}-standard simplex.

A weighted rule is a mapping \eqn{\mathcal{R}:C^N\times \text{Int}(\Delta_N)\rightarrow \mathbb{R}^N}
which associates with a problem \eqn{c\in C^N} and a positive weight vector \eqn{w\in \text{Int}(\Delta_n)} a contribution
vector \eqn{\mathcal{R}(c,w)\in X(c)}.

It is possible to define weighted versions of the rules: SFC, SEC, CEC, CP and CEB. In fact, two different rules
emerge from the standard SEC rule: the weighted SEC rule and the coalition-weighted SEC rule. If \eqn{w_i=w_j} for all \eqn{i,j \in N}, then the solution of weighted SEC\eqn{(c)} and
weighted CSEC\eqn{(c)} coincides.

In all the rules, the higher the weight \eqn{w_i}, the more the corresponding agent will have to pay, except for the weighted CEB rule
(the construction of this rule is based on the concept of allocating 'benefits', so it is logical that it is set up this way).
Furthermore, as previously stated, all the rules, except for the weighted CSEC rule, require the weights to be positive. However, to standardize the criterion,
we establish that the CSEC rule also demands positive weights.

The weighted version of the SFC, SEC, CEC and CP rules is equal to their respective versions for clones, so the formulation of these rules will be the same
for the version with clones. Only the CEB rule has a weighted version and a clone version that are different.
}
\examples{
# All weighted rules with graphical representation
c <- c(1, 3, 3, 7, 10) # Cost vector
w <- c(1, 4, 1, 2, 8) # Weight vector
multiweightedrules(c, w)

# Weighted SEC, CEC and CP rule without plot
c <- c(5, 10, 20)
w <- c(3, 2, 1)
multiweightedrules(c, w, rules = c("SEC", "CEC", "CP"), draw = FALSE,
agents_names = c("Alex", "Estela", "Carmen"))

}
\references{
Bernárdez Ferradás, A., Mirás Calvo, M. Á., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2025a). Airport problems with cloned agents. [Preprint manuscript].

Bernárdez Ferradás, A., Mirás Calvo, M. Á., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2025b). A characterization of the CSEC rule for airport problems. [Prepint manuscript].

Sánchez-Rodríguez, E., Mirás Calvo, M. Á., Quinteiro Sandomingo, C., and Núñez Lugilde, I. (2024). Coalition-weighted Shapley values.
\emph{International Journal of Game Theory}, 53, 547-577.

Thomson, W. (2024). Cost allocation and airport problems.
\emph{Mathematical Social Sciences}, 31(C), 17–31.
}
\seealso{
\code{\link{weightedrule}}, \code{\link{comparisonallocations}}, \code{\link{plotallocations}}
}
