% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotParameterObject.R
\name{acfCSP}
\alias{acfCSP}
\title{Plots ACF for codon specific parameter traces}
\usage{
acfCSP(
  parameter,
  csp = "Mutation",
  numMixtures = 1,
  samples = NULL,
  lag.max = 40,
  plot = TRUE
)
}
\arguments{
\item{parameter}{object of class Parameter}

\item{csp}{indicates which parameter to calculate the autocorrelation. Must be Mutation (the default, ROC, FONSE), Selection (ROC, FONSE), Alpha (PA, PANSE), LambdaPrime (PA, PANSE), NSERate (PA, PANSE)"}

\item{numMixtures}{indicates the number of CSP mixtures used}

\item{samples}{number of samples at the end of the trace used to calculate the acf}

\item{lag.max}{Maximum amount of lag to calculate acf. Default is 10*log10(N), where N i the number of observations.}

\item{plot}{logical. If TRUE (default) a plot of the acf is created}
}
\description{
The function calculates and by defaults plots the acf and estimates the autocorrelation in the trace
}
\seealso{
\code{\link{acfMCMC}}
}
