% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomeObject.R
\name{getCodonCounts}
\alias{getCodonCounts}
\title{Get Codon Counts For all Amino Acids}
\usage{
getCodonCounts(genome)
}
\arguments{
\item{genome}{A genome object from which the counts of each
codon can be obtained.}
}
\value{
Returns a data.frame storing the codon counts for each amino acid.
}
\description{
provides the codon counts for a fiven amino acid across all genes
}
\details{
The returned matrix containes a row for each gene and a column 
for each synonymous codon of \code{aa}.
}
\examples{

genome_file <- system.file("extdata", "genome.fasta", package = "AnaCoDa")
 
## reading genome
genome <- initializeGenomeObject(file = genome_file)
counts <- getCodonCounts(genome)

}
