% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R_CalculateAMIds.R
\name{calculateAMids}
\alias{calculateAMids}
\title{Calculate genetic distances.}
\usage{
calculateAMids(pedtxtFile, fileReferences)
}
\arguments{
\item{pedtxtFile}{Character vector giving path to PED file to be used. The PED file should include all 51 HGDP references and the individuals for which the user wishes to calculate the genetic distance.}

\item{fileReferences}{Character vector giving path to file File detailing the individuals in the ped file that correspond to the references, and the populations they refer to. A file that uses the 51 HGDP reference populations is provided with the package.}
}
\description{
calculates and assigns Ancestry Mapper Ids (AMids) in a more crude, but faster manner than calculateAMids
}
\examples{
\dontrun{
library(AncestryMapper)

HGDP_References <- system.file('extdata',
                               'HGDP_References.txt',
                                package = 'AncestryMapper')


HGDP_500SNPs <- system.file('extdata',
                            'HGDP_500SNPs.ped',
                             package = 'AncestryMapper')

Corpheno <- system.file('extdata',
                        'CorPheno',
                         package = 'AncestryMapper')

genetic.distance <- calculateAMids(pedtxtFile = HGDP_500SNPs,
                                   fileReferences = HGDP_References)

plotAMids(AMids = genetic.distance, phenoFile = Corpheno, columnPlot = "I")
}
}

