% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redundancy.R
\name{redundancy}
\alias{redundancy}
\title{Calculate Observed and Expected Redundancy of Sequences}
\usage{
redundancy(sequences)
}
\arguments{
\item{sequences}{A vector of character strings, where each string represents a sequence of elements separated by spaces.}
}
\value{
A data frame with the following columns:
\item{redundancy}{The observed redundancy in the original sequences. This is the mean proportion of consecutive identical elements across all sequences.}
\item{redundancy_expected_across}{The expected redundancy obtained from sequences where elements have been shuffled across the sequences.}
\item{redundancy_expected_within}{The expected redundancy obtained from sequences where elements have been shuffled within each sequence.}
}
\description{
This function calculates the observed redundancy of sequences and compares it to expected redundancy values obtained from shuffled sequences. The redundancy is defined as the proportion of consecutive identical elements in the sequences.
}
\details{
The function calculates redundancy as the proportion of consecutive identical elements within each sequence. It then compares this observed redundancy to expected values derived from sequences where elements are shuffled either across sequences or within each sequence. The function relies on auxiliary functions `shuffle_sequences_across` and `shuffle_sequences_within` for generating the shuffled sequences.
}
\examples{
# Example sequences
sequences <- c("A A B C C", "B A A C C", "A B C C C")
# Compute redundancy
redundancy(sequences)
}
