% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Band_Depth_Distance.R
\name{all_bands}
\alias{all_bands}
\title{Pairwise band generation in a multivariate time series}
\usage{
all_bands(series)
}
\arguments{
\item{series}{A matrix of n columns representing a multivariate time series,
each column is a univariate time series}
}
\value{
a list with two elements the lowerbounds of all (n)(n-1)/2 pairs
and the upperbounds of the pairwise bands
}
\description{
takes all the pairs of series in a multivariate set and compute the band
between each pair od series
}
\examples{
X=matrix( rnorm(200), ncol=10  )
all_bands(X)

}
\seealso{
Band Depth Clustering for Nonstationary Time Series and
Wind Speed Behavior (2018) Tupper et al
}
