% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distance_matrix_knn_algorithm.R
\name{distance_matrix_PDC}
\alias{distance_matrix_PDC}
\title{Distance matrix from a partial directed coherence measure (PDC)}
\usage{
distance_matrix_PDC(unit, ar, period)
}
\arguments{
\item{unit}{A matrix representing a multivariate time series where each
column is a univariate time series.}

\item{ar}{Integer vector containing all the lags considered for the
vector autoregressive model}

\item{period}{Integer referencing the index of the frequency to use for the
distance. It gives the Hertz or periods per unit of time; i.e., if the
sampling is per minute, and each hour cycle is the period of interest}
}
\value{
a matrix with pairwise distances
}
\description{
Pairwise distance matrix of a multivariate time series based on the
partial directed coherence among two series. The distance considers both
directions of causality and transform it to give 0 in absence of
causality between the series.
}
\examples{
X=matrix( rnorm(2000), ncol=10  )
ar=c(1, 2)
period=10
distance_matrix_PDC(  unit=X, ar,  period )
}
\seealso{
Guillermo Granados, and Idris Eckley. "Electricity Demand of Buildings Benchmarked via Regression Trees on Nearest Neighbors Anomaly Scores"
}
