% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Af_compare_across_repertoires.R
\name{Af_compare_across_repertoires}
\alias{Af_compare_across_repertoires}
\title{A function to compare dynamics of B cell evolution across different repertoires.}
\usage{
Af_compare_across_repertoires(
  AntibodyForests_list,
  metrics,
  plot,
  text.size,
  colors,
  significance,
  parallel,
  num.cores
)
}
\arguments{
\item{AntibodyForests_list}{A list of AntibodyForests objects to compare.}

\item{metrics}{Which metrics to use for comparison. Options are:
. betweenness       : The number of shortest paths that pass through each node (Default)
. degree            : The number of edges connected to each node (Default)
'nr.nodes'         : The total number of nodes
'nr.cells'         : The total number of cells in this clonotype
'mean.depth'       : Mean of the number of edges connecting each node to the germline
'mean.edge.length' : Mean of the edge lengths between each node and the germline
'sackin.index'     : Sum of the number of nodes between each terminal node and the germline, normalized by the number of terminal nodes
'spectral.density' : Metrics of the spectral density profiles (calculated with package RPANDA)
\itemize{
\item peakedness            : Tree balance
\item asymmetry             : Shallow or deep branching events
\item principal eigenvalue  : Phylogenetic diversity
\item modalities            : The number of different structures within the tree
}}

\item{plot}{What kind of plot to make.
boxplot (default)
freqpoly}

\item{text.size}{Font size in the plot (default 20).}

\item{colors}{Optionally specific colors for the groups. If not provided, the default ggplot2 colors are used.}

\item{significance}{If TRUE, the significance of a T test between the groups is plotted in the boxplot (default FALSE)}

\item{parallel}{If TRUE, the metric calculations are parallelized (default FALSE)}

\item{num.cores}{Number of cores to be used when parallel = TRUE. (Defaults to all available cores - 1)}
}
\value{
Plots to compare the repertoires on the supplied metrics.
}
\description{
Compare tree topology metrics across different (groups) of AntibodyForests objects.
}
\examples{
boxplots <- Af_compare_across_repertoires(list("S1" = AntibodyForests::small_af[1],
            "S2" = AntibodyForests::small_af[2]),
            metrics = c("betweenness", "degree"),
            plot = "boxplot")
boxplots$betweenness
}
