% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/climateData.R
\docType{data}
\name{climateData}
\alias{climateData}
\title{Daily Weather Data (1996-2020) from Angochen Weather Observing
Station, Mozambique}
\format{
A data frame containing daily values of weather variables:
\itemize{
\item \strong{Station_Name}: Name of the weather station.
\item \strong{Lat}: Latitude of the site in decimal degrees.
\item \strong{Lon}: Longitude of the site in decimal degrees.
\item \strong{Elev}: Elevation above sea level in meters.
\item \strong{Year}: Year of the record (YYYY).
\item \strong{Month}: Month of the record (MM).
\item \strong{Day}: Day of the record (DD).
\item \strong{Rain}: Daily rainfall in millimeters (mm).
\item \strong{Tmax}: Daily maximum temperature at 2 meters height in degrees Celsius
(°C).
\item \strong{Tmin}: Daily minimum temperature at 2 meters height in degrees Celsius
(°C).
}
}
\source{
INAM - Instituto Nacional de Meteorologia, Mozambique
}
\usage{
data(climateData)
}
\description{
Contains daily weather data obtained from
Instituto Nacional de Meteorologia (INAM). The sample data includes daily raw
weather data from January 1, 1996, to December 31, 2020, from a weather
station located in Angochen, Nampula province of Mozambique.
}
\examples{
## Load the climate data
data(climateData)

## Get the structure of the data frame
str(climateData)

## Get the head of the data frame
head(climateData)

}
\seealso{
\code{\link{AgroClimateData}}, \code{\link{calcEto}}
}
\keyword{datasets}
