% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{loaddata}
\alias{loaddata}
\title{Load mass spectrometer data}
\usage{
loaddata(fname, masses, MS = "ARGUS-VI", PH = FALSE)
}
\arguments{
\item{fname}{the file name, must end with .csv}

\item{masses}{a vector of strings denoting the order of the
isotopes listed in the table}

\item{MS}{the type of mass spectrometer}

\item{PH}{a boolean indicating whether the data are to be treated
as multicollector (PH=FALSE) or 'peak hopping' (PH=TRUE) data. The
default is PH=FALSE.}
}
\value{
if PH=FALSE: an object of class \code{timeresolved}\cr
if PH=TRUE: an object of class \code{PHdata}
}
\description{
Loads a .csv file with raw mass spectrometer data
}
\examples{
samplefile <- system.file("Samples.csv",package="ArArRedux")
masses <- c("Ar37","Ar38","Ar39","Ar40","Ar36")
m <- loaddata(samplefile,masses) # samples and J-standards
plot(m,"MD2-1a","Ar40")
}
