% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aat_splithalf.R
\name{aat_splithalf}
\alias{aat_splithalf}
\alias{print.aat_splithalf}
\alias{plot.aat_splithalf}
\title{Compute the bootstrapped split-half reliability for approach-avoidance task data}
\usage{
aat_splithalf(
  ds,
  subjvar,
  pullvar,
  targetvar = NULL,
  rtvar,
  stratvars = NULL,
  iters,
  algorithm = c("aat_doublemeandiff", "aat_doublemediandiff", "aat_dscore",
    "aat_dscore_multiblock", "aat_regression", "aat_standardregression",
    "aat_singlemeandiff", "aat_singlemediandiff"),
  trialdropfunc = c("prune_nothing", "trial_prune_3SD", "trial_prune_3MAD",
    "trial_prune_SD_dropcases", "trial_recode_SD", "trial_prune_percent_subject",
    "trial_prune_percent_sample", "trial_prune_grubbs"),
  errortrialfunc = c("prune_nothing", "error_replace_blockmeanplus",
    "error_prune_dropcases"),
  casedropfunc = c("prune_nothing", "case_prune_3SD"),
  plot = TRUE,
  include.raw = FALSE,
  parallel = TRUE,
  ...
)

\method{print}{aat_splithalf}(x, coef = c("SpearmanBrown", "Raju", "FlanaganRulon"), ...)

\method{plot}{aat_splithalf}(x, type = c("median", "minimum", "maximum", "random"), ...)
}
\arguments{
\item{ds}{a longformat data.frame}

\item{subjvar}{Quoted name of the participant identifier column}

\item{pullvar}{Quoted name of the column indicating pull trials.
Pull trials should either be represented by 1, or by the second level of a factor.}

\item{targetvar}{Name of the column indicating trials featuring the target stimulus.
Target stimuli should either be represented by 1, or by the second level of a factor.}

\item{rtvar}{Name of the reaction time column.}

\item{stratvars}{Names of additional variables to stratify splits by.}

\item{iters}{Total number of desired iterations. At least 6000 are recommended for reasonable estimates.}

\item{algorithm}{Function (without brackets or quotes) to be used to compute AAT scores. See \link{Algorithms} for a list of usable algorithms.}

\item{trialdropfunc}{Function (without brackets or quotes) to be used to exclude outlying trials in each half.
The way you handle outliers for the reliability computation should mimic the way you do it in your regular analyses.
It is recommended to exclude outlying trials when computing AAT scores using the mean double-dfference scores and regression scoring approaches,
but not when using d-scores or median double-difference scores.
\itemize{
\item \code{prune_nothing} excludes no trials (default)
\item \code{trial_prune_grubbs} applies a Grubbs' test to the data, removing one outlier at a time until the test is no longer significant.
\item \code{trial_prune_3SD} excludes trials deviating more than 3SD from the mean per participant.
\item \code{trial_prune_SD_dropcases} removes trials deviating more than a specific number of standard deviations from the participant's mean,
and removes participants with an excessive percentage of outliers.
Required arguments:
\itemize{
\item \code{trialsd} - trials deviating more than \code{trialsd} standard deviations from the participant's mean are excluded (optional; default is 3)
\item \code{maxoutliers} - participants with a higher percentage of outliers are removed from the data. (optional; default is .15)
}
\item \code{trial_recode_SD} recodes outlying reaction times to the nearest non-outlying value,
with outliers defined as reaction times deviating more than a certain number of standard deviations from the participant's mean. Required argument:
\itemize{
\item \code{trialsd} - trials deviating more than this many standard deviations from the mean are classified as outliers.
}
\item \code{trial_prune_percent_subject} and \code{trial_prune_percent_sample} remove trials below and/or above certain percentiles,
on a subject-by-subject basis or sample-wide, respectively. The following arguments are available:
\itemize{
\item \code{lowerpercent} and \code{uppperpercent} (optional; defaults are .01 and .99).
}
}}

\item{errortrialfunc}{Function (without brackets or quotes) to apply to an error trial.

\itemize{
\item \code{prune_nothing} removes no errors (default).
\item \code{error_replace_blockmeanplus} replaces error trial reaction times with the block mean, plus an arbitrary extra quantity.
If used, the following additional arguments are required:
\itemize{
\item \code{blockvar} - Quoted name of the block variable (mandatory)
\item \code{errorvar} - Quoted name of the error variable, where errors are 1 or TRUE and correct trials are 0 or FALSE (mandatory)
\item \code{errorbonus} - Amount to add to the reaction time of error trials. Default is 0.6 (recommended by \code{Greenwald, Nosek, & Banaji, 2003})
}
\item \code{error_prune_dropcases} removes errors and drops participants if they have more errors than a given percentage. The following arguments are available:
\itemize{
\item \code{errorvar} - Quoted name of the error variable, where errors are 1 or TRUE and correct trials are 0 or FALSE (mandatory)
\item \code{maxerrors} - participants with a higher percentage of errors are excluded from the dataset. Default is .15.
}
}}

\item{casedropfunc}{Function (without brackets or quotes) to be used to exclude outlying participant scores in each half.
The way you handle outliers here should mimic the way you do it in your regular analyses.
\itemize{
\item \code{prune_nothing} excludes no participants (default)
\item \code{case_prune_3SD} excludes participants deviating more than 3SD from the sample mean.
}}

\item{plot}{Create a scatterplot of the AAT scores computed from each half of the data from the last iteration.
This is highly recommended, as it helps to identify outliers that can inflate or diminish the reliability.}

\item{include.raw}{logical indicating whether raw split-half data should be included in the output object.}

\item{parallel}{If TRUE (default), will use parallel computing to compute results faster.
If a doParallel backend has not been registered beforehand,
this function will register a cluster and stop it after finishing, which takes some extra time.}

\item{...}{Other arguments, to be passed on to the algorithm or outlier rejection functions (see arguments above)}

\item{x}{an \code{aat_splithalf} object}

\item{coef}{Optional character argument,
indicating which reliability coefficient should be printed.
Defaults to Raju's beta.}

\item{type}{Character argument indicating which iteration should be chosen. Must be an abbreviation of
\code{"median"} (default), \code{"minimum"}, \code{"maximum"}, or \code{"random"}.}
}
\value{
A list, containing the mean bootstrapped split-half reliability, bootstrapped 95% confidence intervals,
a list of data.frames used over each iteration, and a vector containing the split-half reliability of each iteration.
}
\description{
Compute bootstrapped split-half reliability for approach-avoidance task data.
}
\details{
The calculated split-half coefficients are described in Warrens (2016).
}
\examples{
split <- aat_splithalf(ds=erotica[erotica$is_irrelevant==0,],
                       subjvar="subject", pullvar="is_pull", targetvar="is_target",
                       rtvar="RT", stratvars="stimuluscode", iters=10,
                       trialdropfunc="trial_prune_3SD",
                       casedropfunc="case_prune_3SD", algorithm="aat_dscore",
                       plot=FALSE, parallel=FALSE)

print(split)
#Mean reliability: 0.521959
#Spearman-Brown-corrected r: 0.6859041
#95\%CI: [0.4167018, 0.6172474]

plot(split)

\donttest{
#Regression Splithalf
aat_splithalf(ds=erotica[erotica$is_irrelevant==0,],
              subjvar="subject", pullvar="is_pull", targetvar="is_target",
              rtvar="RT", iters=10, trialdropfunc="trial_prune_3SD",
              casedropfunc="case_prune_3SD", algorithm="aat_regression",
              formula = RT ~ is_pull * is_target, aatterm = "is_pull:is_target",
              plot=FALSE, parallel=FALSE)
#Mean reliability: 0.5313939
#Spearman-Brown-corrected r: 0.6940003
#95\%CI: [0.2687186, 0.6749176]
}
}
\references{
Warrens, M. J. (2016). A comparison of reliability coefficients for
psychometric tests that consist of two parts.
Advances in Data Analysis and Classification, 10(1), 71-84.
}
\seealso{
\link{q_reliability}
}
\author{
Sercan Kahveci
}
