% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ACSN_Enrichment.R
\name{enrichment}
\alias{enrichment}
\title{Gene set enrichment analysis}
\usage{
enrichment(Genes = NULL, maps = c("Apoptosis", "CellCycle", "DNA_repair",
  "EMT_motility", "Survival"), correction_multitest = "BH",
  statistical_test = "fisher", min_module_size = 5,
  universe = "map_defined", Remove_from_universe = NULL, threshold = 0.05,
  alternative = "greater")
}
\arguments{
\item{Genes}{Character vector of genes that should be tested for enrichment}

\item{maps}{list of maps generated by format_from_gmt. Names of element of list will be used to track modules.
Default: tests on the master map.}

\item{correction_multitest}{either FALSE, "bonferroni", "holm", "hochberg", "hommel", "BH", "fdr" (identical to BH), or "BY"}

\item{statistical_test}{one of "fisher", "hypergeom"}

\item{min_module_size}{will remove from the analysis all modules which are (strictly) smaller than threshold}

\item{universe}{Universe on which the statistical analysis should be performed. 
Can be either "HUGO","ACSN","map_defined", or a character vector of genes.}

\item{Remove_from_universe}{Default is NULL. A list of genes that should not be considered for enrichment 
(will be removed from input, maps, and universe). The size of universe and map will be updated after removal.}

\item{threshold}{maximal p-value (corrected if correction is enabled) that will be displayed}

\item{alternative}{One of "greater", "less", "both" or "two.sided"
Greater will check for enrichment, less will check for depletion, and both will look for 
both and will keep track of the side,
while two-sided (only for fisher test) checks if there is a difference.}
}
\value{
Output is a dataframe with the following columns:\describe{
 \item{module}{The name of the map or the module preceded by the map}
 \item{module_size}{The number of genes in the module after taking into account universe reduction}
 \item{nb_genes_in_module}{The number of genes from input list in the module}
 \item{genes_in_module}{Names of the genes from input list in the module, space separated}
 \item{universe_size}{size of the input universe}
 \item{nb_genes_in_universe}{number of genes from the input list that are found in the universe}
 \item{test}{the kind of test that was looked for. "greater" when enrichment is tested, "less" when depletion is tested, or "two.sided"}
}
}
\description{
Compute and represent gene set enrichment from your data based on pre-saved maps from ACSN or user imported maps. 
The gene set enrichment can be run with hypergeometric test or Fisher exact test, 
and can use multiple corrections. Visualization of data can be done either by barplots or heatmaps.
}
\examples{
enrichment(genes_test,min_module_size = 10, 
   threshold = 0.05,
   maps = list(cellcycle = ACSNMineR::ACSN_maps$CellCycle),
   universe = "ACSN")
}

