% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onlyDeconAlgorithms.R
\name{spillToConvergence}
\alias{spillToConvergence}
\title{Build an n-pass spillover matrix, continuing until the results converge into clusters of cell types}
\usage{
spillToConvergence(sigMatrix, geneExpr, nPasses = 100, plotIt = FALSE,
  imputNAs = FALSE)
}
\arguments{
\item{sigMatrix}{The deconvolution matrix, e.g. LM22 or MGSM27}

\item{geneExpr}{The source gene expression matrix used to calculate sigMatrix}

\item{nPasses}{The maximum number of iterations (DEFAULT: 100)}

\item{plotIt}{Set to TRUE to plot it (DEFAULT: FALSE)}

\item{imputNAs}{Set to TRUE to imput genes with missing values & cache the imputed.  FALSE will just remove them (DEFAULT: FALSE)}
}
\value{
A list of signature matrices
}
\description{
deconMatrices <- spillToConvergence(sigMatrix, geneExpr, 100, FALSE, TRUE)
}
\examples{
#This toy example 
library(ADAPTS)
fullLM22 <- ADAPTS::LM22[1:30, 1:4]
smallLM22 <- fullLM22[1:25,] 

deconMatrices <- spillToConvergence(sigMatrix=smallLM22, geneExpr=fullLM22, nPasses=10, plotIt=TRUE)
}
