% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Parallel.R
\name{ParallelCV}
\alias{ParallelCV}
\title{Parallel CV (uses CV_ADMMsigmac)}
\usage{
ParallelCV(X = NULL, S = NULL, lam = 10^seq(-5, 5, 0.5), alpha = seq(0,
  1, 0.1), diagonal = FALSE, rho = 2, mu = 10, tau1 = 2, tau2 = 2,
  crit = "ADMM", tol1 = 1e-04, tol2 = 1e-04, maxit = 1000, K = 5,
  cores = 1, quiet = TRUE)
}
\arguments{
\item{X}{option to provide a nxp matrix. Each row corresponds to a single observation and each column contains n observations of a single feature/variable.}

\item{S}{option to provide a pxp sample covariance matrix (denominator n). If argument is \code{NULL} and \code{X} is provided instead then \code{S} will be computed automatically.}

\item{lam}{tuning parameter for elastic net penalty. Defaults to grid of values \code{10^seq(-5, 5, 0.5)}.}

\item{alpha}{elastic net mixing parameter contained in [0, 1]. \code{0 = ridge, 1 = lasso}. Defaults to grid of values \code{seq(-1, 1, 0.1)}.}

\item{diagonal}{option to penalize the diagonal elements of the estimated precision matrix (\eqn{\Omega}). Defaults to \code{FALSE}.}

\item{rho}{initial step size for ADMM algorithm.}

\item{mu}{factor for primal and residual norms in the ADMM algorithm. This will be used to adjust the step size \code{rho} after each iteration.}

\item{tau1}{factor in which to increase step size \code{rho}}

\item{tau2}{factor in which to decrease step size \code{rho}}

\item{crit}{criterion for convergence (\code{ADMM}, \code{grad}, or \code{loglik}). If \code{crit != ADMM} then \code{tol1} will be used as the convergence tolerance. Default is \code{ADMM}.}

\item{tol1}{absolute convergence tolerance. Defaults to 1e-4.}

\item{tol2}{relative convergence tolerance. Defaults to 1e-4.}

\item{maxit}{maximum number of iterations.}

\item{K}{specify the number of folds for cross validation.}

\item{cores}{option to run CV in parallel. Defaults to \code{cores = 1}.}

\item{quiet}{specify whether the function returns progress of CV or not.}
}
\value{
returns list of returns which includes:
\item{lam}{optimal tuning parameter.}
\item{alpha}{optimal tuning parameter.}
\item{cv.error}{cross validation error for optimal parameters.}
\item{cv.errors}{cross validation errors.}
}
\description{
Parallel implementation of cross validation.
}
\keyword{internal}
