% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFMVariogramAnalyser.R
\name{calculateOmnidirectionalVariogram}
\alias{calculateOmnidirectionalVariogram}
\title{Calculate experimental omnidirectional semi-variogram}
\usage{
calculateOmnidirectionalVariogram(AFMImageVariogramAnalysis, AFMImage)
}
\arguments{
\item{AFMImageVariogramAnalysis}{an \code{\link{AFMImageVariogramAnalysis}} to manage and store the result of variogram analysis}

\item{AFMImage}{an \code{\link{AFMImage}} from Atomic Force Microscopy}
}
\value{
the semivariance calculated in all the directions
}
\description{
\code{calculateOmnidirectionalVariogram} returns the semivariance calculated for all the directions
calculate the experimental omnidirectional variogram of an \code{\link{AFMImage}} with the \code{\link[gstat]{variogram}} function of the gstat package.
The experimental semi-variogram is used to fit (find the best sill and range) the theoretical variogram models.
With 512*512 images, it takes several minutes to calculate.
}
\examples{
\dontrun{
library(AFM)
library(ggplot2)

data(AFMImageOfRegularPeaks)
variogramAnalysis<-AFMImageVariogramAnalysis(sampleFitPercentage=3.43)
avario<-AFM::calculateOmnidirectionalVariogram(AFMImageVariogramAnalysis= variogramAnalysis, 
                                               AFMImage= AFMImageOfRegularPeaks)
dist<-gamma<-NULL
p <- ggplot(avario, aes(x=dist, y=gamma))
p <- p + geom_point()
p <- p + geom_line()
p <- p + ylab("semivariance")
p <- p + xlab("distance (nm)")
p <- p + ggtitle("Experimental semivariogram")
p
}
}
\author{
M.Beauvais
}

