% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFMPSDAnalyser.R
\name{performAllPSDCalculation}
\alias{performAllPSDCalculation}
\title{Perform all the calculation for PSD exploitation}
\usage{
performAllPSDCalculation(AFMImagePSDAnalysis, AFMImage)
}
\arguments{
\item{AFMImagePSDAnalysis}{an \code{\link{AFMImagePSDAnalysis}} to manage and store the results of PSD analysis}

\item{AFMImage}{an \code{\link{AFMImage}} from Atomic Force Microscopy}
}
\description{
\code{\link{performAllPSDCalculation}} perform all the calculation for PSD exploitation
}
\examples{
\dontrun{
library(AFM)

data(AFMImageOfNormallyDistributedHeights)

newAFMImage<-AFMImageOfNormallyDistributedHeights
newAFMImage@fullfilename<-"C:/Users/one/AFMImageOfNormallyDistributedHeights.txt"
psdAnalysis<-AFMImagePSDAnalysis()
# Create a closure to update progress
psdAnalysis@updateProgress<- function(value = NULL, detail = NULL, message = NULL) {
  if (exists("progressPSD")){
    if (!is.null(message)) {
      progressPSD$set(message = message, value = 0)
    }else{
      progressPSD$set(value = value, detail = detail)
    }
  }
}
psdAnalysis@psd1d_breaks<-2^3
psdAnalysis@psd2d_truncHighLengthScale<-TRUE
psdAnalysis<-performAllPSDCalculation(AFMImagePSDAnalysis= psdAnalysis, AFMImage= newAFMImage)
print("done psdAnalysis")
}
}
\author{
M.Beauvais
}
