% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bp.R
\name{bp}
\alias{bp}
\title{Breusch-Pagan test}
\usage{
bp(model, varformula = NULL, studentize = TRUE, data = list())
}
\arguments{
\item{model}{is a (generalized)linear regression model}

\item{varformula}{a formula describing only the potential explanatory variables for the variance (no dependent variable needed). By default the same explanatory variables are taken as in the main regression model.}

\item{studentize}{logical. If set to TRUE Koenker's studentized version of the test statistic will be used.}

\item{data}{an optional data frame containing the variables in the model}
}
\value{
Textual result of the test.
List of values:
\item{BP}{test statistics}
\item{p-value}{p-value of the BP test}
}
\description{
Breusch-Pagan test is used to test against heteroskedasticity of a time-series
}
\references{
Torsten, H., Zeileis, A., Farebrother, Richard W., Cummins, C., Millo, G., Mitchell, D., lmtest package
Wang, B., 2014, bstats package
}
