% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AGD-package.R
\docType{data}
\name{References WHO}
\alias{References WHO}
\alias{who.bmi}
\alias{who.hgt}
\alias{who.wfh}
\alias{who.wfl}
\alias{who.wgt}
\title{References WHO}
\format{A data frame with seven variables:
\describe{
\item{pop}{Study Population (always \code{"who"})}
\item{sub}{Subpopulation (always \code{"N"})}
\item{sex}{Sex (M, F)}
\item{x}{Decimal age, height (cm) or length(cm)}
\item{L}{Lambda (skewness) curve}
\item{M}{Median curve}
\item{S}{Coefficient of variation}
}}
\source{
WHO Multicentre Growth Reference Study Group.  WHO Child Growth
Standards based on length/height, weight and age.  \emph{Acta Paediatr},
Suppl. 2006, 450, 76-85.

de Onis M, Onyango AW, Borghi E, Siyam A, Nishida C, Siekmann J.
Development of a WHO growth reference for school-aged children and adolescents
\emph{Bulletin of the World Health Organization}, 2007;85:660-7.
}
\description{
Reference tables, combined from the WHO Multicentre Growth Reference
Study (MGRS) (ages 0-5 years) and the WHO 2007 reference (5-19 years).
}
\details{
The data were fitted by the LMS model. Parameters are stored as type
\code{LMS}. Tabulated values are point ages.

The naming conventions are as follows:
\describe{
\item{who.hgt}{Length (cm, 0-2 Yrs) or height (cm, 2-19 years)}
\item{who.wgt}{Weight (kg) for age (0-10 years)}
\item{who.bmi}{BMI (kg/m^2) for age (0-19 years)}
\item{who.wfh}{Weight (kg) for height (65-120 cm)}
\item{who.wfl}{Weight (kg) for length (45-110 cm)}
}
}
\seealso{
\code{\link{nl4.wgt}}, \code{\link{cdc.wgt}},
\url{http://www.who.int/childgrowth/mgrs/en/},
\url{http://www.who.int/growthref/en/}
}
\keyword{datasets}

