% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mcheck.R
\name{Mcheck}
\alias{Mcheck}
\title{Check and filter markers}
\usage{
Mcheck(
  SNPmatrix = NULL,
  ploidy = 2,
  missingValue = -9,
  thresh.maf = 0.05,
  thresh.missing = 0.9,
  thresh.htzy = 0,
  impute.method = "mean",
  rmv.mono = TRUE
)
}
\arguments{
\item{SNPmatrix}{matrix (n x m), where n is is individual names and m is marker names (coded inside the matrix as 0, 1, 2, ..., ploidy, and, missingValue).}

\item{ploidy}{data ploidy (an even number between 2 and 20). Default=2.}

\item{missingValue}{missing value in data. Default=-9.}

\item{thresh.maf}{minimum allele frequency accepted to each marker. Default=0.05.}

\item{thresh.missing}{threshold on missing data, SNPs below of this frequency value will be maintained, if equal to 1, no threshold and imputation is considered. Default = 0.50.}

\item{thresh.htzy}{threshold heterozigosity, remove SNPs below this threshold. Default=0.}

\item{impute.method}{"mean" to impute the missing data by the mean per marker, "mode" to impute the missing data by the mode per marker, "global.mean" to impute the missing data by the mean across all markers, "global.mode" to impute the missing data my the mode across all marker. Default = "mean".}

\item{rmv.mono}{if monomorphic markers should be removed. Default=TRUE.}
}
\value{
SNPmatrix after filtering steps.
}
\description{
This function does different filtering on the marker matrix
}
\examples{
data(snp.pine)
M = Mcheck(snp.pine)

}
\author{
Luis F V Ferrao and Rodrigo Amadeu, \email{rramadeu@gmail.com}
}
