% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcs.R
\name{create_stock}
\alias{create_stock}
\alias{reset_stock}
\title{Functions for creating and filling stock objects.}
\usage{
create_stock()

reset_stock(stock, stock_params, mp_params, app_params, initial_biomass,
  nyears, niters)
}
\arguments{
\item{stock}{A list with elements biomass, hcr_ip, hcr_op, effort and catch.}

\item{stock_params}{A vector of life history and stochasticy parameters.}

\item{mp_params}{A vector of management procedure parameters.}

\item{app_params}{A vector of application parameters.}

\item{initial_biomass}{The initial biomass of the population.}

\item{nyears}{The numbers of years to set the stock up for.}

\item{niters}{The numbers of iters to set the stock up for.}
}
\value{
A reactiveValues object with bits for the stock.

A filled stock object (a reactiveValues object with bits for the stock).
}
\description{
A stock is made up of biomass, hcr_ip, hcr_op, effort and catch.
create_stock() makes the empty reactive stock object for AMPED apps.
It has the elements but they are empty.

reset_stock() clears out an existing stock and refills the initial period depending on the stock status option (over, fully, underexploited).
}
\examples{
# Making a NULL stock
create_stock()

# Resetting a stock
# Managment procedure bits - should come from Shiny app inputs
input_mp <- list(
  blim_belbow = c(0.2, 0.5),
  cmin_cmax = c(10, 140), 
  constant_catch_level = 50,
  constant_effort_level = 1,
  emin_emax = c(0.1, 0.5),
  hcr_type = "threshold_catch")
mp_params <- mp_params_switcheroo(input_mp)

# Stochasticity bits - should come from Shiny app inputs
input_stoch <- list(
  biol_est_bias = 0,
  biol_est_sigma = 0,
  biol_prod_sigma = 0, 
  show_var <- TRUE)
stoch_params <- set_stoch_params(input_stoch)

# Life history bits - should come from Shiny app inputs
input_lh <- list(
  stock_history = "fully",
  stock_lh = "medium")
lh_params <- get_lh_params(input_lh)

# Stitch together and make other parameters - should be inside an Shiny app 
stock_params <- c(stoch_params, lh_params)
app_params <- list(initial_year = 2009, last_historical_timestep = 10)

# Make the null stock and fill it up
# In a Shiny app use the create_stock() function but cannot do here so make an equivalent object
stock <- list(biomass = NULL, hcr_ip = NULL, hcr_op = NULL, effort = NULL, catch = NULL)

# Reset the stock
stock <- reset_stock(stock = stock, stock_params = stock_params, mp_params = mp_params,
  app_params = app_params, initial_biomass = stock_params$b0, nyears = 20, niters = 10)
}
