% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eucast.R
\name{EUCAST_rules}
\alias{EUCAST_rules}
\alias{interpretive_reading}
\title{EUCAST expert rules}
\source{
EUCAST Expert Rules Version 2.0: \cr
  Leclercq et al. \strong{EUCAST expert rules in antimicrobial susceptibility testing.} \emph{Clin Microbiol Infect.} 2013;19(2):141-60. \cr
  \url{https://doi.org/10.1111/j.1469-0691.2011.03703.x} \cr
  \cr
  EUCAST Expert Rules Version 3.1 (Intrinsic Resistance and Exceptional Phenotypes Tables): \cr
  \url{http://www.eucast.org/fileadmin/src/media/PDFs/EUCAST_files/Expert_Rules/Expert_rules_intrinsic_exceptional_V3.1.pdf}
}
\usage{
EUCAST_rules(tbl, col_bactid = "bactid", info = TRUE, amcl = "amcl",
  amik = "amik", amox = "amox", ampi = "ampi", azit = "azit",
  aztr = "aztr", cefa = "cefa", cfra = "cfra", cfep = "cfep",
  cfot = "cfot", cfox = "cfox", cfta = "cfta", cftr = "cftr",
  cfur = "cfur", chlo = "chlo", cipr = "cipr", clar = "clar",
  clin = "clin", clox = "clox", coli = "coli", czol = "czol",
  dapt = "dapt", doxy = "doxy", erta = "erta", eryt = "eryt",
  fosf = "fosf", fusi = "fusi", gent = "gent", imip = "imip",
  kana = "kana", levo = "levo", linc = "linc", line = "line",
  mero = "mero", mino = "mino", moxi = "moxi", nali = "nali",
  neom = "neom", neti = "neti", nitr = "nitr", novo = "novo",
  norf = "norf", oflo = "oflo", peni = "peni", pita = "pita",
  poly = "poly", qida = "qida", rifa = "rifa", roxi = "roxi",
  siso = "siso", teic = "teic", tetr = "tetr", tica = "tica",
  tige = "tige", tobr = "tobr", trim = "trim", trsu = "trsu",
  vanc = "vanc")

interpretive_reading(...)
}
\arguments{
\item{tbl}{table with antibiotic columns, like e.g. \code{amox} and \code{amcl}}

\item{col_bactid}{column name of the bacteria ID in \code{tbl} - values of this column should be present in \code{microorganisms$bactid}, see \code{\link{microorganisms}}}

\item{info}{print progress}

\item{amcl, amik, amox, ampi, azit, aztr, cefa, cfra, cfep, cfot, cfox, cfta, cftr, cfur, chlo, cipr, clar, clin, clox, coli, czol, dapt, doxy, erta, eryt, fosf, fusi, gent, imip, kana, levo, linc, line, mero, mino, moxi, nali, neom, neti, nitr, novo, norf, oflo, peni, pita, poly, qida, rifa, roxi, siso, teic, tetr, tica, tige, tobr, trim, trsu, vanc}{column names of antibiotics. Use \code{NA} to skip a column, like \code{tica = NA}. Non-existing column will be skipped.}

\item{...}{parameters that are passed on to \code{EUCAST_rules}}
}
\value{
table with edited variables of antibiotics.
}
\description{
Apply expert rules (like intrinsic resistance), as defined by the European Committee on Antimicrobial Susceptibility Testing (EUCAST, \url{http://eucast.org}), see \emph{Source}.
}
\examples{
a <- EUCAST_rules(septic_patients)
a <- data.frame(bactid = c("STAAUR",  # Staphylococcus aureus
                           "ENCFAE",  # Enterococcus faecalis
                           "ESCCOL",  # Escherichia coli
                           "KLEPNE",  # Klebsiella pneumoniae
                           "PSEAER"), # Pseudomonas aeruginosa
                vanc = "-",           # Vancomycin
                amox = "-",           # Amoxicillin
                coli = "-",           # Colistin
                cfta = "-",           # Ceftazidime
                cfur = "-",           # Cefuroxime
                stringsAsFactors = FALSE)
a

b <- EUCAST_rules(a)
b
}
