% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_locale.R
\name{translate}
\alias{translate}
\alias{get_locale}
\title{Translate strings from AMR package}
\usage{
get_locale()
}
\description{
For language-dependent output of AMR functions, like \code{\link{mo_fullname}} and \code{\link{mo_type}}.
}
\details{
Strings will be translated to foreign languages if they are defined in a local translation file. Additions to this file can be suggested at our repository. The file can be found here: \url{https://gitlab.com/msberends/AMR/blob/master/data-raw/translations.tsv}.

Please suggest your own translations \href{https://gitlab.com/msberends/AMR/issues/new?issue[title]=Translation\%20suggestion}{by creating a new issue on our repository}.

This file will be read by all functions where a translated output can be desired, like all \code{\link{mo_property}} functions (\code{\link{mo_fullname}}, \code{\link{mo_type}}, etc.).

The system language will be used at default, if supported, using \code{\link{get_locale}}. The system language can be overwritten with \code{\link{getOption}("AMR_locale")}.
}
\section{Read more on our website!}{

On our website \url{https://msberends.gitlab.io/AMR} you can find \href{https://msberends.gitlab.io/AMR/articles/AMR.html}{a tutorial} about how to conduct AMR analysis, the \href{https://msberends.gitlab.io/AMR/reference}{complete documentation of all functions} (which reads a lot easier than here in R) and \href{https://msberends.gitlab.io/AMR/articles/WHONET.html}{an example analysis using WHONET data}.
}

\examples{
# The 'language' parameter of below functions
# will be set automatically to your system language
# with get_locale()

# English
mo_fullname("CoNS", language = "en")
#> "Coagulase-negative Staphylococcus (CoNS)"

# German
mo_fullname("CoNS", language = "de")
#> "Koagulase-negative Staphylococcus (KNS)"

# Dutch
mo_fullname("CoNS", language = "nl")
#> "Coagulase-negatieve Staphylococcus (CNS)"

# Spanish
mo_fullname("CoNS", language = "es")
#> "Staphylococcus coagulasa negativo (SCN)"

# Italian
mo_fullname("CoNS", language = "it")
#> "Staphylococcus negativo coagulasi (CoNS)"

# Portuguese
mo_fullname("CoNS", language = "pt")
#> "Staphylococcus coagulase negativo (CoNS)"
}
