% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOPA-convert.R
\name{conversion}
\alias{conversion}
\alias{toWide}
\alias{toLong}
\alias{toCompiled}
\title{Converting between formats}
\usage{
toWide(w)

toLong(w)

toCompiled(w)
}
\arguments{
\item{w}{An instance of an ANOPA object.}
}
\value{
A data frame in the requested format.
}
\description{
The functions 'toWide()', 'toLong()', and 'toCompiled()'
converts the data into various formats.
}
\details{
The proportions of success of a set of \emph{n} participants can be
given using many formats. In what follows, \emph{n} is the number of
participants, \emph{p} is the number of between-subject factor(s),
$q$ is the number of repeated-measure factor(s).
\itemize{
\item One basic format, called \code{wide}, has one line per
participants, with a 1 if a "success" is observed
or a 0 if no success is observed. What a succes is
is entirely arbitrary. The proportion of success is then
the number of 1s divided by the number of participants in each group.
The data frame has $n$ lines and $p+q$ columns.
\item A second format, called \code{long}, has, on a line, the
factor name(s) and 1s or 0s to indicate success or not.
The data fame has $n x q$ lines and
4 columns (a Id column to identify the particpant; $p$ columns
to identify the groups, one column to identify which whitin-subject
measure is given and finally, a 1 or 0 for the score of that measurement.
\item A third format, called \code{compiled}, is to have a list of all
the between-subject factors and the number of
success and the total number of participants.
This format is more compact  as if there are 6 groups,
the data are all contained in six lines (one line per group).
This format however is only valid for between-subject design as
we cannot infer the correlation between successes/failure.
}

See the vignette \href{../articles/B-DataFormatsForProportions.html}{DataFormatsForProportions}
for more.
}
\examples{

# The minimalBSExample contains $n$ of 175 participants categorized according
# to one factor $f = 1$, namely `State of residency` (with three levels) 
# for 3 possible cells.
minimalBSExample

# Lets incorporate the data in an ANOPA data structure
w <- anopa( {s;n} ~ state, minimalBSExample )

# The data presented using various formats looks like
toWide(w)
# ... has 175 lines, one per participants ($n$) and 2 columns (state, success or failure)

toLong(w)
# ... has 175 lines ($n x f$) and 4 columns (participant's `Id`, state name, measure name, 
# and success or failure)

toCompiled(w)
# ... has 3 lines and 3 columns ($f$ + 2: number of succes and number of participants).


# This second example is from a mixed-design. It indicates the 
# state of a machine, grouped in three categories (the sole between-subject
# factor) and at four different moments. 
# The four measurements times are before treatment, post-treatment, 
# 1 week later, and finally, 5 weeks later.
minimalMxExample

# Lets incorporate the data in an ANOPA data structure
w <- anopa( cbind(bpre,bpost,b1week,b5week) ~ Status, 
            minimalMxExample,
            WSFactors = "Moment(4)" )

# -- Wide format --
# Wide format is actually the format of minimalMxExample
# (27 lines with 8 subjects in the first group and 9 in the second)
toWide(w)

# -- Long format --
# (27 times 4 lines = 108 lines, 4 columns, that is Id, group, measurement, success or failure)
toLong(w)

# -- Compiled format --
# (three lines as there are three groups, 7 columns, that is, 
# the group, the 4 measurements, the number of particpants, and the
# correlation between measurements for each group measured by unitary alphas)
toCompiled(w)



}
