% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardise_names.R
\name{standardise_names}
\alias{standardise_names}
\title{Standardise Taxon Names}
\usage{
standardise_names(taxon_names)
}
\arguments{
\item{taxon_names}{A character vector of taxon names that need to be standardised.}
}
\value{
A character vector of standardised taxon names.
}
\description{
This function standardises taxon names by performing a series of text
substitutions to remove common inconsistencies in taxonomic nomenclature.
The function takes a character vector of taxon names as input and returns a
character vector of taxon names using standardised taxonomic syntax as output. In particular it standardises
the abbreviations used to document infraspecific taxon ranks (subsp., var., f.),
as people use many variants of these terms. It also standardises or removes a few additional filler
words used within taxon names (affinis becomes aff.; s.l. and s.s. are removed).
}
\examples{
standardise_names(c("Quercus suber",
                    "Eucalyptus sp.",
                    "Eucalyptus spp.",
                    "Agave americana var. marginata",
                    "Agave americana v marginata",
                    "Notelaea longifolia forma longifolia",
                    "Notelaea longifolia f longifolia"))
}
