% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/APIS_functions.R
\name{personalThreshold}
\alias{personalThreshold}
\title{Establish personal threshold}
\usage{
personalThreshold(APIS.result, method, threshold = NULL,
  verbose = TRUE)
}
\arguments{
\item{APIS.result}{APIS function output}

\item{method}{the method for the new threshold | 'delta' for deltas,
'Pmendel' for Mendelian porbabilities, 'exclusion' for mismatches}

\item{threshold}{personal threshold | default values are implemented}

\item{verbose}{(default : TRUE) Display the process of the function on the console.}
}
\value{
new pedigree from the new threshold
}
\description{
This function allows the user to set up his own threshold
}
\examples{
data("APIS_offspring")
data("APIS_sire")
data("APIS_dam")

result <- APIS(off.genotype = APIS_offspring[1:50, ],
               sire.genotype = APIS_sire,
               dam.genotype = APIS_dam,
               error = 0.05,
               verbose = FALSE)

new.result <- personalThreshold(result, method = 'exclusion', threshold = 2, verbose = FALSE)

}
\keyword{APIS}
\keyword{assignment}
\keyword{threshold}
