% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_clone_sizes.R
\name{countCloneSizes}
\alias{countCloneSizes}
\title{count the number of clonotype sizes in a seurat object combined with a
VDJ library overall or by cluster}
\usage{
countCloneSizes(
  seurat_obj,
  clonecall = "strict",
  extra_filter = NULL,
  ...,
  by_cluster = TRUE,
  sort_decreasing = NULL
)
}
\arguments{
\item{seurat_obj}{a seurat object combined with a VDJ library with the
\code{scRepertoire}.}

\item{clonecall}{character. The column name in the seurat object metadata to
use. See \code{scRepertoire} documentation for more information about this
parameter that is central to both packages.}

\item{extra_filter}{character. An additional string that should be formatted
\emph{exactly} like a statement one would pass into \link[dplyr:filter]{dplyr::filter} that does
\emph{additional} filtering to cells in the seurat object - on top of the other
keyword arguments - based on the metadata. This means that it will be
logically AND'ed with any keyword argument filters. This is a more flexible
alternative / addition to the filtering keyword arguments. For example, if
one wanted to filter by the length of the amino acid sequence of TCRs, one
could pass in something like \code{extra_filter = "nchar(CTaa) - 1 > 10"}. When
involving characters, ensure to enclose with single quotes.}

\item{...}{additional "subsetting" keyword arguments indicating the rows
corresponding to elements in the seurat object metadata that should be
filtered by. E.g., \code{seurat_clusters = c(1, 9, 10)} will filter the cells to
those in the \code{seurat_clusters} column with any of the values 1, 9, and 10.
Unfortunately, column names in the seurat object metadata cannot
conflict with the keyword arguments. \emph{\strong{MAJOR NOTE}} if any subsetting
keyword arguments are a \emph{prefix} of any preceding argument names (e.g. a
column named \code{reduction} is a prefix of the \code{reduction_base} argument)
R will interpret it as the same argument unless \emph{both} arguments
are named. Additionally, this means any subsequent arguments \emph{must} be named.}

\item{by_cluster}{Logical or Character. If \code{TRUE}, will output a list of
table objects, with the table at each index corresponding to level in
Idents(). Each table's names are the clonotype name indicated by \code{clonecall}
after filtering, while the values are the actual clone sizes. If \code{FALSE},
outputs just the aggregate clone sizes for all cells. Note that if \code{FALSE},
the output should be identical to that produced by
\code{mergeCloneSizes(countCloneSizes(..., by_cluster = TRUE))}. Otherwise, this
argument can also be a character indicating some column in the seurat object
metadata to use a cell identity guiding (e.g. \code{"seurat_clusters"}).}

\item{sort_decreasing}{a logical or NULL. If \code{TRUE}/\code{FALSE}, sorts each/the
table by clonotype frequency with largest/smallest clones first with a stable
sorting algorithm, and if NULL, no order is guaranteed but the output is
deterministic.}
}
\value{
A list of tables or a single table depending on \code{by_cluster}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Get clonotype frequencies from a seurat object's metadata, either as one
whole table, or in a list of tables, based on the current / some custom
ident of each cell. Note that depending on the ident (indicated by the
\code{by_cluster} argument) there may be more or less clonotypes counted based
on the number of rows containing NA for that column of that ident if it
isn't the active ident.
}
\examples{
data("combined_pbmc")

countCloneSizes(combined_pbmc)
countCloneSizes(combined_pbmc, "aa")
countCloneSizes(combined_pbmc, "nt", orig.ident = c("P17B", "P17L"))

}
\seealso{
\link{mergeCloneSizes}
}
