% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insert_legend.R
\name{removeLegend}
\alias{removeLegend}
\title{Remove current APackOfTheClones legend}
\usage{
removeLegend(apotc_ggplot)
}
\arguments{
\item{apotc_ggplot}{a ggplot object that is the output of \link{APOTCPlot} or
\link{vizAPOTC}}
}
\value{
A ggplot object of the APackOfTheClones clonal expansion plot of the
seurat object. There is an additional 10th element in the object named
\code{"APackOfTheClones"} used by other functions in this package and shouldn't
interfere with any other ggplot functionality. (As far as currently known)
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Removes the clone size legend on an APackOfTheClones plot, if
one is present. Will preserve any additional ggplot layers.
}
\examples{
# create an APackOfTheClones plot with a legend
apotc_plot <- vizAPOTC(
    get(data("combined_pbmc")),
    add_size_legend = TRUE,
    verbose = FALSE
)

# remove the legend
apotc_plot <- removeLegend(apotc_plot)
apotc_plot

}
\seealso{
\link{overlayLegend}
}
