% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_wave.R
\name{clip_wave}
\alias{clip_wave}
\title{Clip multiple wave files and format names}
\usage{
clip_wave(
  waves,
  dir_out,
  dir_in = NULL,
  col_path_in = path,
  col_subdir_out = subdir_out,
  col_filename_out = filename_out,
  col_clip_length = clip_length,
  col_start_time = start_time,
  overwrite = FALSE,
  create_dir = TRUE,
  diff_limit = 30,
  use_job = FALSE
)
}
\arguments{
\item{waves}{Data frame. Details of file locations.}

\item{dir_out}{Character. Output directory.}

\item{dir_in}{Character. Directory wave files are read from. Default is
\code{NULL} meaning the current working directory.}

\item{col_path_in}{Column. Unquoted column containing the current file paths.
Default \code{path}.
\strong{Note: file paths must be either relative to \code{dir_in} or absolute}.}

\item{col_subdir_out}{Column. Unquoted column containing the
subdirectories in which to put output files. Default \code{subdir_out}.}

\item{col_filename_out}{Column. Unquoted column containing the output
filenames. Default \code{filename_out}.}

\item{col_clip_length}{Column. Unquoted column containing the length of the
new clip. Default \code{length}.}

\item{col_start_time}{Column. Unquoted column containing the start time of
the new clip. Default \code{start_time}.}

\item{overwrite}{Logical. Overwrite pre-existing files when clipping and
moving. Default \code{FALSE}.}

\item{create_dir}{Logical. Whether to create directory structure for newly
formatted and clipped wave files.}

\item{diff_limit}{Numeric. How much longer in seconds clip lengths can be
compared to file lengths before triggering an error. Default \code{30}.}

\item{use_job}{Logical. Use the 'job' package to copy files Default \code{FALSE}.}
}
\value{
TRUE if successful and clipped wave files created
}
\description{
Process multiple wave files by copying them with a new filename and
clipping to a given length.
}
\examples{
\dontshow{if (dir.exists("test1")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
w <- data.frame(
  path = temp_wavs(n = 4),
  subdir_out = c("test1/a", "test2/a", "test3/c", "test4/d"),
  subsub_dir_out = rep("zz", 4),
  filename_out = c("wave1_clean.wav", "wave2_clean.wav", "wave3_clean.wav", "wave4_clean.wav"),
  clip_length = c(1, 1, 1, 2),
  start_time = c(1.2, 0.5, 1, 0)
)

clip_wave(w, dir_out = "clean", col_subdir_out = c(subdir_out, subsub_dir_out))

unlink("clean", recursive = TRUE) # Remove this new 'clean' directory
\dontshow{\}) # examplesIf}
}
