% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATA_Accuracy.R
\name{ATA.Accuracy}
\alias{ATA.Accuracy}
\title{Accuracy Measures for The ATAforecasting}
\usage{
ATA.Accuracy(object, out.sample = NULL, print.out = TRUE)
}
\arguments{
\item{object}{An object of class \code{ata} is required.}

\item{out.sample}{A numeric vector or time series of class \code{ts} or \code{msts} for out-sample.}

\item{print.out}{Default is TRUE. If FALSE, summary of ATA Method's accuracy measures is not shown.}
}
\value{
Matrix giving forecast accuracy measures.
}
\description{
Returns ATA(p,q,phi)(E,T,S) applied to `ata` \code{object}.
Accuracy measures for a forecast model
Returns range of summary measures of the forecast accuracy. If \code{out.sample} is
provided, the function measures test set forecast accuracy.
If \code{out.sample} is not provided, the function only produces
training set accuracy measures.
The measures calculated are:
\itemize{
	 \item{lik}		: maximum likelihood functions
	 \item{sigma}	: residual variance.
	 \item{MAE}		: mean absolute error.
	 \item{MSE}		: mean square error.
	 \item{RMSE}	: root mean squared error.
	 \item{MPE}		: mean percentage error.
	 \item{MAPE}	: mean absolute percentage error.
	 \item{sMAPE}	: symmetric mean absolute percentage error.
	 \item{MASE}	: mean absolute scaled error.
	 \item{OWA}		: overall weighted average of MASE and sMAPE.
	 \item{MdAE}	: median absolute error.
	 \item{MdSE}	: median square error.
	 \item{RMdSE}	: root median squared error.
	 \item{MdPE}	: median percentage error.
	 \item{MdAPE}	: median absolute percentage error.
	 \item{sMdAPE}	: symmetric median absolute percentage error.
}
}
\examples{
trainATA <-  head(touristTR, 84)
testATA <- window(touristTR, start = 2015, end = 2016.917)
ata_fit <- ATA(trainATA, h=24, seasonal.test = TRUE, seasonal.model = "decomp")
ata_accuracy <- ATA.Accuracy(ata_fit, testATA)

}
\references{
#'\insertRef{hyndmanandkoehler2006}{ATAforecasting}

#'\insertRef{hyndman2019forecasting}{ATAforecasting}
}
\seealso{
\code{forecast}, \code{stlplus}, \code{stR}, \code{\link[stats]{stl}}, \code{\link[stats]{decompose}}, \code{tbats}, \code{seasadj}.
}
\author{
Ali Sabri Taylan and Hanife Taylan Selamlar
}
\keyword{Ata}
\keyword{accuracy}
\keyword{forecast}
\keyword{msts}
\keyword{ts}
