% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmt.r
\name{GMT}
\alias{GMT}
\alias{read.GMT}
\alias{gmt}
\alias{write.GMT}
\alias{is.GMT}
\title{Read and Write GMT files}
\format{
A GMT object is a named list of terms, where each term is a list with the items:
\describe{
    \item{id}{The term ID.}
    \item{name}{The full name or description of the term.}
    \item{genes}{A character vector of genes annotated to this term.}
  }
}
\usage{
read.GMT(filename)

write.GMT(gmt, filename)

is.GMT(x)
}
\arguments{
\item{filename}{Location of the gmt file.}

\item{gmt}{A GMT object.}

\item{x}{The object to test.}
}
\value{
\code{read.GMT} returns a GMT object. \cr
\code{write.GMT} returns NULL. \cr
\code{is.GMT} returns TRUE if \code{x} is a GMT object, else FALSE.
}
\description{
Functions to read and write Gene Matrix Transposed (GMT) files and to test if
an object inherits from GMT.
}
\details{
A GMT file describes gene sets, such as biological terms and pathways. GMT files are 
tab delimited text files. Each row of a GMT file contains a single term with its 
database ID and a term name, followed all genes annotated to the term.
}
\examples{
  fname_GMT <- system.file("extdata", "hsapiens_REAC_subset.gmt", package = "ActivePathways")
  gmt <- read.GMT(fname_GMT)
  gmt[1:10]
  gmt[[1]]
  gmt[[1]]$id
  gmt[[1]]$genes
  gmt[[1]]$name
  gmt$`REAC:1630316`
}
