% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMGauss.R
\name{EMGauss}
\alias{EMGauss}
\title{EM Algorithm for GMM}
\usage{
EMGauss(Data, K = NULL, Means = NULL, SDs = NULL, Weights = NULL,
  MaxNumberofIterations = 10, fast = F)
}
\arguments{
\item{Data}{vector of data points}

\item{K}{estimated amount of Gaussian Kernels}

\item{Means}{vector(1:L), Means of Gaussians, L == Number of Gaussians}

\item{SDs}{estimated Gaussian Kernels = standard deviations}

\item{Weights}{optional, relative number of points in Gaussians (prior probabilities): sum(Weights) ==1, default weight is 1/L}

\item{MaxNumberofIterations}{Optional, Number of Iterations; default=10}

\item{fast}{Default: FALSE: Using mclust's EM see function densityMclust of that package, TRUE: Naive but faster EM implementation, which may be numerical unstable, because log(gauss) is not used}
}
\value{
List With 
\describe{
  \item{Means:}{means of GMM generated by EM algorithm}
  \item{SDs:}{standard deviations of GMM generated by EM algorithm}
  \item{Weights:}{prior probabilities of Gaussians}
}
}
\description{
Expectation-Maximization algorithm to calculate optimal Gaussian Mixture Model for given data in one Dimension.
}
\details{
No adding or removing of Gaussian kernels. Number of Gaussian hast to be set by the length of the vector of Means, SDs and Weights. This EM is only for univariate data. For multivariate data see package mclust
}
\references{
Bishop, Christopher M. Pattern recognition and machine learning. springer, 2006, p 435 ff

\strong{See Also}

AdaptGauss
}
\author{
Onno Hansen-Goos, Michael Thrun, Florian Lerch
}
