% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adherer.R
\name{CMA0}
\alias{CMA0}
\title{CMA0 constructor.}
\usage{
CMA0(data = NULL, ID.colname = NA, event.date.colname = NA,
  event.duration.colname = NA, event.daily.dose.colname = NA,
  medication.class.colname = NA, carryover.within.obs.window = NA,
  carryover.into.obs.window = NA, carry.only.for.same.medication = NA,
  consider.dosage.change = NA, followup.window.start = NA,
  followup.window.start.unit = NA, followup.window.duration = NA,
  followup.window.duration.unit = NA, observation.window.start = NA,
  observation.window.start.unit = NA, observation.window.duration = NA,
  observation.window.duration.unit = NA, date.format = "\%m/\%d/\%Y",
  summary = "Base CMA object", suppress.warnings = FALSE, ...)
}
\arguments{
\item{data}{A \emph{\code{data.frame}} containing the medication events
(prescribing or dispensing) used to compute the CMA. Must contain, at a
minimum, the patient unique ID, the event date and duration, and might also
contain the daily dosage and medication type (the actual column names are
defined in the following four parameters).}

\item{ID.colname}{A \emph{string}, the name of the column in \code{data}
containing the unique patient ID, or \code{NA} if not defined.}

\item{event.date.colname}{A \emph{string}, the name of the column in
\code{data} containing the start date of the event (in the format given in
the \code{date.format} parameter), or \code{NA} if not defined.}

\item{event.duration.colname}{A \emph{string}, the name of the column in
\code{data} containing the event duration (in days), or \code{NA} if not
defined.}

\item{event.daily.dose.colname}{A \emph{string}, the name of the column in
\code{data} containing the prescribed daily dose, or \code{NA} if not defined.}

\item{medication.class.colname}{A \emph{string}, the name of the column in
\code{data} containing the classes/types/groups of medication, or \code{NA}
if not defined.}

\item{carryover.within.obs.window}{\emph{Logical}, if \code{TRUE} consider
the carry-over within the observation window, or \code{NA} if not defined.}

\item{carryover.into.obs.window}{\emph{Logical}, if \code{TRUE} consider the
carry-over from before the starting date of the observation window, or
\code{NA} if not defined.}

\item{carry.only.for.same.medication}{\emph{Logical}, if \code{TRUE} the
carry-over applies only across medications of the same type, or \code{NA}
if not defined.}

\item{consider.dosage.change}{\emph{Logical}, if \code{TRUE} the carry-over
is adjusted to reflect changes in dosage, or \code{NA} if not defined.}

\item{followup.window.start}{If a \emph{\code{Date}} object, it represents
the actual start date of the follow-up window; if a \emph{string} it is the
name of the column in \code{data} containing the start date of the follow-up
window either as the numbers of \code{followup.window.start.unit} units
after the first event (the column must be of type \code{numeric}) or as
actual dates (in which case the column must be of type \code{Date}); if a
\emph{number} it is the number of time units defined in the
\code{followup.window.start.unit} parameter after the begin of the
participant's first event; or \code{NA} if not defined.}

\item{followup.window.start.unit}{can be either \emph{"days"},
\emph{"weeks"}, \emph{"months"} or \emph{"years"}, and represents the time
units that \code{followup.window.start} refers to (when a number), or
\code{NA} if not defined.}

\item{followup.window.duration}{either a \emph{number} representing the
duration of the follow-up window in the time units given in
\code{followup.window.duration.unit}, or a \emph{string} giving the column
containing these numbers. Should represent a period for which relevant
medication events are recorded accurately (e.g. not extend after end of
relevant treatment, loss-to-follow-up or change to a health care provider
not covered by the database).}

\item{followup.window.duration.unit}{can be either \emph{"days"},
\emph{"weeks"}, \emph{"months"} or \emph{"years"}, and represents the time
units that \code{followup.window.duration} refers to, or \code{NA} if not
defined.}

\item{observation.window.start, observation.window.start.unit, observation.window.duration, observation.window.duration.unit}{the definition of the observation window
(see the follow-up window parameters above for details).}

\item{date.format}{A \emph{string} giving the format of the dates used in
the \code{data} and the other parameters; see the \code{format} parameters
of the \code{\link[base]{as.Date}} function for details (NB, this concerns
only the dates given as strings and not as \code{Date} objects).}

\item{summary}{Metadata as a \emph{string}, briefly describing this CMA.}

\item{suppress.warnings}{\emph{Logical}, if \code{TRUE} don't show any
warnings.}

\item{...}{other possible parameters}
}
\value{
An \code{S3} object of class \code{CMA0} with the following fields:
\itemize{
 \item \code{data} The actual event (prescribing or dispensing) data, as
 given by the \code{data} parameter.
 \item \code{ID.colname} the name of the column in \code{data} containing
 the unique patient ID, as given by the \code{ID.colname} parameter.
 \item \code{event.date.colname} the name of the column in \code{data}
 containing the start date of the event (in the format given in the
 \code{date.format} parameter), as given by the \code{event.date.colname}
 parameter.
 \item \code{event.duration.colname} the name of the column in \code{data}
 containing the event duration (in days), as given by the
 \code{event.duration.colname} parameter.
 \item \code{event.daily.dose.colname} the name of the column in \code{data}
 containing the prescribed daily dose, as given by the
 \code{event.daily.dose.colname} parameter.
 \item \code{medication.class.colname} the name of the column in \code{data}
 containing the classes/types/groups of medication, as given by the
 \code{medication.class.colname} parameter.
 \item \code{carryover.within.obs.window} whether to consider the carry-over
 within the observation window, as given by the
 \code{carryover.within.obs.window} parameter.
 \item \code{carryover.into.obs.window} whether to consider the carry-over
 from before the starting date of the observation window, as given by the
 \code{carryover.into.obs.window} parameter.
 \item \code{carry.only.for.same.medication} whether the carry-over applies
 only across medication of the same type, as given by the
 \code{carry.only.for.same.medication} parameter.
 \item \code{consider.dosage.change} whether the carry-over is adjusted to
 reflect changes in dosage, as given by the \code{consider.dosage.change}
 parameter.
 \item \code{followup.window.start} the beginning of the follow-up window,
 as given by the \code{followup.window.start} parameter.
 \item \code{followup.window.start.unit} the time unit of the
 \code{followup.window.start}, as given by the
 \code{followup.window.start.unit} parameter.
 \item \code{followup.window.duration} the duration of the follow-up window,
 as given by the \code{followup.window.duration} parameter.
 \item \code{followup.window.duration.unit} the time unit of the
 \code{followup.window.duration}, as given by the
 \code{followup.window.duration.unit} parameter.
 \item \code{observation.window.start} the beginning of the observation
 window, as given by the \code{observation.window.start} parameter.
 \item \code{observation.window.start.unit} the time unit of the
 \code{observation.window.start}, as given by the
 \code{observation.window.start.unit} parameter.
 \item \code{observation.window.duration} the duration of the observation
 window, as given by the \code{observation.window.duration} parameter.
 \item \code{observation.window.duration.unit} the time unit of the
 \code{observation.window.duration}, as given by the \code{observation.window.duration.unit} parameter.
 \item \code{date.format} the format of the dates, as given by the
 \code{date.format} parameter.
 \item \code{summary} the metadata, as given by the \code{summary}
 parameter.
}
}
\description{
Constructs a basic CMA (continuous multiple-interval measures of medication
availability/gaps) object.
}
\details{
In most cases this should not be done directly by the user,
but it is used internally by the other CMAs.
}
\examples{
cma0 <- CMA0(data=med.events,
             ID.colname="PATIENT_ID",
             event.date.colname="DATE",
             event.duration.colname="DURATION",
             event.daily.dose.colname="PERDAY",
             medication.class.colname="CATEGORY",
             followup.window.start=0,
             followup.window.start.unit="days",
             followup.window.duration=2*365,
             followup.window.duration.unit="days",
             observation.window.start=30,
             observation.window.start.unit="days",
             observation.window.duration=365,
             observation.window.duration.unit="days",
             date.format="\%m/\%d/\%Y",
             summary="Base CMA");
}
