#' 3-hourly pollen data of Munich and Viechtach (2018), obtained automatically by BAA500
#'
#' A dataset containing information of 3-hourly concentrations of pollen in the atmosphere of Munich (DEBIED) and Viechtach (DEVIEC) during the year 2018. Pollen types included: \emph{"Poaceae"} and \emph{"Pinus"}.
#' @format Time series of 3-hours pollen concentrations expressed as pollen grains / m3 of air.
#' @details Data were obtained by the automatic pollen monitor BAA500 from Munich and Viechtach in Bavaria (Germany) \code{data("POMO_pollen")}, supplied by the public ePIN Network supported by the Bavarian Government. The ePIN Network was built by Das Bayerische Landesamt für Gesundheit und Lebensmittelsicherheit (LGL) in collaboration with Zentrum Allergie und Umwelt (ZAUM).
#'@references Oteros, J., et al., ... & Buters, J. T. (2019). Building an automatic Pollen Monitoring Network (ePIN): Selection of optimal sites by clustering pollen stations.
#'@references Oteros, J., Pusch, G., Weichenmeier, I., Heimann, U., Mueller, R., Roeseler, S., ... & Buters, J. T. (2015). Automatic and online pollen monitoring.
#' @references Hirst, J.M., 1952. AN AUTOMATIC VOLUMETRIC SPORE TRAP. Ann. Appl. Biol. 39, 257_265.
#' @references VDI 4252_4. (2016). Bioaerosole und biologische Agenzien_Ermittlung von Pollen und Sporen in der Aussenluft unterVerwendung  einer volumetrischen  Methode  fuer  einMessnetz zu allergologischen Zwecken. VDI_Richtlinie4252 Blatt 4, Entwurf. VDI/DIN_Handbuch Reinhaltungder Luft, Band 1a: Beuth, Berlin
#' @source \url{https://www.lgl.bayern.de/}
#' @source \url{https://www.zaum-online.de/}
"POMO_pollen"
